/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.tasks;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.progress.IncrementalProgressMonitor;
import net.pcal.fastback.progress.PercentageProgressMonitor;
import net.pcal.fastback.tasks.PushTask;
import net.pcal.fastback.utils.GitUtils;
import net.pcal.fastback.utils.SnapshotId;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.GC;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.storage.pack.PackConfig;

public class GcTask
implements Callable<Void> {
    private final ModContext ctx;
    private final Logger log;
    private final Git git;
    private long sizeBeforeBytes;
    private long sizeAfterBytes;

    public GcTask(Git git, ModContext ctx, Logger log) {
        this.git = Objects.requireNonNull(git);
        this.ctx = Objects.requireNonNull(ctx);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public Void call() throws Exception {
        File gitDir = this.git.getRepository().getDirectory();
        this.log.hud(Message.localized("fastback.hud.gc-percent", 0));
        this.log.info("Stats before gc:");
        this.log.info("" + this.git.gc().getStatistics());
        this.sizeBeforeBytes = FileUtils.sizeOfDirectory((File)gitDir);
        this.log.info("Backup size before gc: " + FileUtils.byteCountToDisplaySize((long)this.sizeBeforeBytes));
        if (this.ctx.isReflogDeletionEnabled()) {
            Path reflogsDir = gitDir.toPath().resolve("logs");
            this.log.info("Deleting reflogs " + reflogsDir);
            net.pcal.fastback.utils.FileUtils.rmdir(reflogsDir);
        }
        if (this.ctx.isBranchCleanupEnabled()) {
            ArrayList<String> branchesToDelete = new ArrayList<String>();
            for (Ref ref : this.git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call()) {
                String branchName = GitUtils.getBranchName(ref);
                if (branchName == null) {
                    this.log.warn("Non-branch ref returned by branchList: " + ref);
                    continue;
                }
                if (PushTask.isTempBranch(branchName)) {
                    branchesToDelete.add(branchName);
                    continue;
                }
                if (SnapshotId.isSnapshotBranchName(branchName)) continue;
                this.log.warn("Unidentified branch found " + branchName + " - consider removing it with 'git branch -D'");
            }
            if (branchesToDelete.isEmpty()) {
                this.log.info("No branches to clean up");
            } else {
                this.log.info("Deleting branches: " + branchesToDelete);
                this.git.branchDelete().setForce(true).setBranchNames(branchesToDelete.toArray(new String[0])).call();
                this.log.info("Branches deleted.");
            }
        }
        GC gc = new GC((FileRepository)this.git.getRepository());
        gc.setExpireAgeMillis(0L);
        gc.setPackExpireAgeMillis(0L);
        gc.setAuto(false);
        PackConfig pc = new PackConfig();
        pc.setDeltaCompress(false);
        gc.setPackConfig(pc);
        IncrementalProgressMonitor pm = new IncrementalProgressMonitor(new GcProgressMonitor(this.log), 100);
        gc.setProgressMonitor((ProgressMonitor)pm);
        this.log.info("Starting garbage collection");
        gc.gc();
        this.log.info("Garbage collection complete.");
        this.log.info("Stats after gc:");
        this.log.info("" + this.git.gc().getStatistics());
        this.sizeAfterBytes = FileUtils.sizeOfDirectory((File)gitDir);
        this.log.info("Backup size after gc: " + FileUtils.byteCountToDisplaySize((long)this.sizeAfterBytes));
        return null;
    }

    public long getBytesReclaimed() {
        return this.sizeBeforeBytes - this.sizeAfterBytes;
    }

    private static class GcProgressMonitor
    extends PercentageProgressMonitor {
        private final Logger logger;

        public GcProgressMonitor(Logger logger) {
            this.logger = Objects.requireNonNull(logger);
        }

        @Override
        public void progressStart(String task) {
            this.logger.info(task);
        }

        @Override
        public void progressUpdate(String task, int percentage) {
            this.logger.info(task + " " + percentage + "%");
            if (task.contains("Writing objects")) {
                this.logger.hud(Message.localized("fastback.hud.gc-percent", percentage * 9 / 10));
            } else if (task.contains("Selecting commits")) {
                this.logger.hud(Message.localized("fastback.hud.gc-percent", 90 + percentage / 20));
            } else if (task.contains("Prune loose objects")) {
                this.logger.hud(Message.localized("fastback.hud.gc-percent", 95 + percentage / 20));
            }
        }

        @Override
        public void progressDone(String task) {
            this.logger.info("Done " + task);
        }

        public void showDuration(boolean enabled) {
        }
    }
}

