/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.tasks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.tasks.JGitSupplier;
import net.pcal.fastback.utils.SnapshotId;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;

public class ListSnapshotsTask
implements Callable<ListMultimap<String, SnapshotId>> {
    private final JGitSupplier<Collection<Ref>> refProvider;
    private final Logger logger;

    public static ListMultimap<String, SnapshotId> listSnapshots(Git git, Logger log) throws GitAPIException, IOException {
        JGitSupplier<Collection<Ref>> refProvider = () -> git.branchList().call();
        return new ListSnapshotsTask(refProvider, log).call();
    }

    public static ListMultimap<String, SnapshotId> listRemoteSnapshots(Git git, WorldConfig wc, Logger log) throws GitAPIException, IOException {
        JGitSupplier<Collection<Ref>> refProvider = () -> git.lsRemote().setRemote(wc.getRemoteName()).setHeads(true).call();
        return new ListSnapshotsTask(refProvider, log).call();
    }

    public ListSnapshotsTask(JGitSupplier<Collection<Ref>> refProvider, Logger logger) {
        this.logger = Objects.requireNonNull(logger);
        this.refProvider = Objects.requireNonNull(refProvider);
    }

    @Override
    public ListMultimap<String, SnapshotId> call() throws GitAPIException, IOException {
        ArrayListMultimap snapshotsPerWorld = ArrayListMultimap.create();
        Collection<Ref> refs = this.refProvider.get();
        for (Ref ref : refs) {
            SnapshotId sid;
            try {
                sid = Objects.requireNonNull(SnapshotId.fromBranchRef(ref));
            }
            catch (ParseException pe) {
                this.logger.warn("Ignoring unrecognized branch " + ref.getName());
                continue;
            }
            snapshotsPerWorld.put((Object)sid.worldUuid(), (Object)sid);
        }
        return snapshotsPerWorld;
    }
}

