/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.tasks;

import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.retention.RetentionPolicy;
import net.pcal.fastback.retention.RetentionPolicyCodec;
import net.pcal.fastback.tasks.JGitConsumer;
import net.pcal.fastback.tasks.JGitSupplier;
import net.pcal.fastback.tasks.ListSnapshotsTask;
import net.pcal.fastback.utils.SnapshotId;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class LocalPruneTask
implements Callable<Collection<SnapshotId>> {
    private final ModContext ctx;
    private final Logger log;
    private final Git git;

    public LocalPruneTask(Git git, ModContext ctx, Logger log) {
        this.git = Objects.requireNonNull(git);
        this.ctx = Objects.requireNonNull(ctx);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public Collection<SnapshotId> call() throws IOException, GitAPIException {
        WorldConfig wc = WorldConfig.load(this.git);
        return LocalPruneTask.doPrune(wc, this.ctx, this.log, wc::localRetentionPolicy, () -> ListSnapshotsTask.listSnapshots(this.git, this.ctx.getLogger()), sid -> {
            this.log.info("Pruning local snapshot " + sid.getName());
            this.git.branchDelete().setForce(true).setBranchNames(new String[]{sid.getBranchName()}).call();
        }, "fastback.chat.retention-policy-not-set");
    }

    static Collection<SnapshotId> doPrune(WorldConfig wc, ModContext ctx, Logger log, JGitSupplier<String> policyConfigFn, JGitSupplier<ListMultimap<String, SnapshotId>> listSnapshotsFn, JGitConsumer<SnapshotId> deleteSnapshotsFn, String notSetKey) throws IOException, GitAPIException {
        String policyConfig = policyConfigFn.get();
        RetentionPolicy policy = RetentionPolicyCodec.INSTANCE.decodePolicy(ctx, ctx.getRetentionPolicyTypes(), policyConfig);
        if (policy == null) {
            log.chatError(Message.localized(notSetKey, new Object[0]));
            return null;
        }
        Collection<SnapshotId> toPrune = policy.getSnapshotsToPrune(SnapshotId.sortWorldSnapshots(listSnapshotsFn.get(), wc.worldUuid()));
        log.hud(Message.localized("fastback.hud.prune-started", new Object[0]));
        for (SnapshotId sid : toPrune) {
            deleteSnapshotsFn.accept(sid);
        }
        return toPrune;
    }
}

