/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.tasks;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.pcal.fastback.ModContext;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.tasks.ListSnapshotsTask;
import net.pcal.fastback.tasks.LocalPruneTask;
import net.pcal.fastback.utils.GitUtils;
import net.pcal.fastback.utils.SnapshotId;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class RemotePruneTask
implements Callable<Collection<SnapshotId>> {
    private final ModContext ctx;
    private final Logger log;
    private final Git git;

    public RemotePruneTask(Git git, ModContext ctx, Logger log) {
        this.git = Objects.requireNonNull(git);
        this.ctx = Objects.requireNonNull(ctx);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public Collection<SnapshotId> call() throws IOException, GitAPIException {
        WorldConfig wc = WorldConfig.load(this.git);
        return LocalPruneTask.doPrune(wc, this.ctx, this.log, wc::remoteRetentionPolicy, () -> ListSnapshotsTask.listRemoteSnapshots(this.git, wc, this.ctx.getLogger()), sid -> {
            this.log.info("Pruning remote snapshot " + sid.getName());
            GitUtils.deleteRemoteBranch(this.git, wc.getRemoteName(), sid.getBranchName());
        }, "fastback.chat.remote-retention-policy-not-set");
    }
}

