/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.tasks;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import net.pcal.fastback.WorldConfig;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.logging.Message;
import net.pcal.fastback.progress.IncrementalProgressMonitor;
import net.pcal.fastback.progress.PercentageProgressMonitor;
import net.pcal.fastback.utils.FileUtils;
import net.pcal.fastback.utils.SnapshotId;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;

public class RestoreSnapshotTask
implements Callable<Path> {
    private final String repoUri;
    private final SnapshotId sid;
    private final Path restoreTargetDir;
    private final String worldName;
    private final Logger logger;

    public RestoreSnapshotTask(String repoUri, Path saveDir, String worldName, SnapshotId sid, Logger logger) {
        this.repoUri = Objects.requireNonNull(repoUri);
        this.restoreTargetDir = Objects.requireNonNull(saveDir);
        this.sid = Objects.requireNonNull(sid);
        this.worldName = Objects.requireNonNull(worldName);
        this.logger = Objects.requireNonNull(logger);
    }

    @Override
    public Path call() throws Exception {
        Path restoreDir = RestoreSnapshotTask.getTargetDir(this.restoreTargetDir, this.worldName, this.sid.getName());
        String branchName = this.sid.getBranchName();
        this.logger.hud(Message.localized("fastback.hud.restore-percent", 0));
        IncrementalProgressMonitor pm = new IncrementalProgressMonitor(new RestoreProgressMonitor(this.logger), 100);
        Git git = Git.cloneRepository().setProgressMonitor((ProgressMonitor)pm).setDirectory(restoreDir.toFile()).setBranchesToClone(List.of("refs/heads/" + branchName)).setBranch(branchName).setURI(this.repoUri).call();
        if (git != null) {
            git.close();
        }
        FileUtils.rmdir(restoreDir.resolve(".git"));
        restoreDir.resolve(WorldConfig.WORLD_UUID_PATH).toFile().delete();
        return restoreDir;
    }

    private static Path getTargetDir(Path saveDir, String worldName, String snapshotName) {
        Path base;
        worldName = worldName.replaceAll("\\W+", "");
        Path candidate = base = saveDir.resolve(worldName + "-" + snapshotName);
        int i = 0;
        while (candidate.toFile().exists()) {
            candidate = Path.of(base + "_" + ++i, new String[0]);
            if (i <= 1000) continue;
            throw new IllegalStateException("wat i = " + i);
        }
        return candidate;
    }

    private static class RestoreProgressMonitor
    extends PercentageProgressMonitor {
        private final Logger logger;

        public RestoreProgressMonitor(Logger logger) {
            this.logger = Objects.requireNonNull(logger);
        }

        @Override
        public void progressStart(String task) {
        }

        @Override
        public void progressUpdate(String task, int percentage) {
            this.logger.info(task + " " + percentage);
            if (task.contains("Receiving")) {
                percentage /= 2;
            } else if (task.contains("Checking")) {
                percentage = 50 + percentage / 2;
            } else {
                return;
            }
            this.logger.hud(Message.localized("fastback.hud.restore-percent", percentage));
        }

        @Override
        public void progressDone(String task) {
        }

        public void showDuration(boolean enabled) {
        }
    }
}

