/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.utils;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.pcal.fastback.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class GitUtils {
    @Deprecated
    public static String getBranchName(Ref fromBranchRef) {
        String REFS_HEADS = "refs/heads/";
        String name = fromBranchRef.getName();
        if (name.startsWith("refs/heads/")) {
            return name.substring("refs/heads/".length());
        }
        return null;
    }

    public static URIish getRemoteUri(Git git, String remoteName, Logger logger) throws GitAPIException {
        Objects.requireNonNull(git);
        Objects.requireNonNull(remoteName);
        List remotes = git.remoteList().call();
        for (RemoteConfig remote : remotes) {
            logger.debug("getRemoteUri " + remote);
            if (!remote.getName().equals(remoteName)) continue;
            return remote.getPushURIs() != null && !remote.getURIs().isEmpty() ? (URIish)remote.getURIs().get(0) : null;
        }
        return null;
    }

    public static void deleteRemoteBranch(Git git, String remoteName, String remoteBranchName) throws GitAPIException {
        RefSpec refSpec = new RefSpec().setSource(null).setDestination("refs/heads/" + remoteBranchName);
        git.push().setRefSpecs(new RefSpec[]{refSpec}).setRemote(remoteName).call();
    }

    public static boolean isGitRepo(Path worldSaveDir) {
        File dotGit = worldSaveDir.resolve(".git").toFile();
        return dotGit.exists() && dotGit.isDirectory();
    }

    public static String getFileUri(Path localPath) {
        return "file://" + localPath.toAbsolutePath();
    }
}

