/*
 * Decompiled with CFR 0.152.
 */
package net.pcal.fastback.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.NavigableSet;
import java.util.TreeSet;
import net.pcal.fastback.logging.Logger;
import net.pcal.fastback.utils.GitUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.jetbrains.annotations.NotNull;

public record SnapshotId(String worldUuid, Date snapshotDate) implements Comparable<SnapshotId>
{
    private static final String PREFIX = "snapshots";
    private static final String SEP = "/";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    public static ListMultimap<String, SnapshotId> getSnapshotsPerWorld(Iterable<Ref> refs, Logger logger) throws GitAPIException {
        ArrayListMultimap out = ArrayListMultimap.create();
        for (Ref ref : refs) {
            String branchName = GitUtils.getBranchName(ref);
            if (branchName == null) continue;
            try {
                SnapshotId sid = SnapshotId.fromBranch(branchName);
                if (sid == null) continue;
                out.put((Object)sid.worldUuid(), (Object)sid);
            }
            catch (ParseException e) {
                logger.warn("Ignoring unexpected branch name " + branchName);
            }
        }
        return out;
    }

    public static SnapshotId fromBranchRef(Ref ref) throws ParseException {
        String REFS_HEADS = "refs/heads/";
        String name = ref.getName();
        if (!name.startsWith("refs/heads/")) {
            throw new ParseException("Not a branch ref " + ref, -1);
        }
        name = name.substring("refs/heads/".length());
        return SnapshotId.fromBranch(name);
    }

    public static SnapshotId fromBranch(String rawBranchName) throws ParseException {
        if (!rawBranchName.startsWith("snapshots/")) {
            throw new ParseException("Not a snapshot branch " + rawBranchName, 0);
        }
        String[] segments = rawBranchName.split(SEP);
        if (segments.length < 3) {
            throw new ParseException("too few segments " + rawBranchName, segments.length);
        }
        String worldUuid = segments[1];
        Date date = DATE_FORMAT.parse(segments[2]);
        return new SnapshotId(worldUuid, date);
    }

    public static SnapshotId create(String worldUuid) {
        return new SnapshotId(worldUuid, new Date());
    }

    public static SnapshotId create(String worldUuid, Date date) {
        return new SnapshotId(worldUuid, date);
    }

    public static SnapshotId fromUuidAndName(String worldUuid, String snapshotDate) throws ParseException {
        return new SnapshotId(worldUuid, DATE_FORMAT.parse(snapshotDate));
    }

    public static boolean isSnapshotBranchName(String branchName) {
        return branchName.startsWith("snapshots/");
    }

    public static NavigableSet<SnapshotId> sortWorldSnapshots(ListMultimap<String, SnapshotId> snapshotsPerWorld, String worldUuid) {
        return new TreeSet<SnapshotId>(snapshotsPerWorld.get((Object)worldUuid));
    }

    public String getName() {
        return DATE_FORMAT.format(this.snapshotDate);
    }

    public String getBranchName() {
        String formattedDate = DATE_FORMAT.format(this.snapshotDate);
        return "snapshots/" + this.worldUuid + SEP + formattedDate;
    }

    @Override
    public int compareTo(@NotNull SnapshotId o) {
        return this.snapshotDate.compareTo(o.snapshotDate);
    }

    @Override
    public String toString() {
        return this.getBranchName();
    }
}

