/*
 * Decompiled with CFR 0.152.
 */
package net.lizistired.cavedust;

import com.minelittlepony.common.util.GamePaths;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.lizistired.cavedust.CaveDustConfig;
import net.lizistired.cavedust.utils.KeybindingHelper;
import net.lizistired.cavedust.utils.MathHelper;
import net.lizistired.cavedust.utils.ParticleSpawnUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaveDust
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cavedust");
    private static CaveDust instance;
    private static CaveDustConfig config;

    public static CaveDust getInstance() {
        return instance;
    }

    public CaveDust() {
        instance = this;
    }

    public CaveDustConfig getConfig() {
        return config;
    }

    public void onInitializeClient() {
        Path CaveDustFolder = GamePaths.getConfigDirectory().resolve("cavedust");
        config = new CaveDustConfig(CaveDustFolder.getParent().resolve("cavedust.json"), this);
        config.load();
        KeybindingHelper.registerKeyBindings();
        ClientTickEvents.END_CLIENT_TICK.register(this::createCaveDust);
    }

    private void createCaveDust(class_310 client) {
        if (KeybindingHelper.keyBinding1.method_1436()) {
            this.getConfig().toggleCaveDust();
            LOGGER.info("Toggled dust");
            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)("debug.cavedust.toggle." + config.getCaveDustEnabled())), false);
        }
        if (KeybindingHelper.keyBinding2.method_1436()) {
            this.getConfig().load();
            LOGGER.info("Reloaded config");
            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"debug.cavedust.reload"), false);
        }
        if (client.field_1687 == null) {
            return;
        }
        class_638 world = client.field_1687;
        double probabilityNormalized = MathHelper.normalize(config.getLowerLimit(), config.getUpperLimit(), client.field_1724.method_31478());
        int i = 0;
        while ((double)i < probabilityNormalized * (double)config.getParticleMultiplier() * 10.0) {
            try {
                double x = client.field_1724.method_19538().method_10216() + MathHelper.generateRandomDouble(config.getDimensionsMinX(), config.getDimensionsMaxX());
                double y = client.field_1724.method_19538().method_10214() + MathHelper.generateRandomDouble(config.getDimensionsMinX(), config.getDimensionsMaxY());
                double z = client.field_1724.method_19538().method_10215() + MathHelper.generateRandomDouble(config.getDimensionsMinX(), config.getDimensionsMaxZ());
                class_2338 particlePos = new class_2338(x, y, z);
                if (!ParticleSpawnUtil.shouldParticlesSpawn(client, config, particlePos)) {
                    return;
                }
                world.method_8406(config.getParticle(), x, y, z, (double)config.getVelocityRandomnessRandom(), (double)config.getVelocityRandomnessRandom(), (double)config.getVelocityRandomnessRandom());
            }
            catch (NullPointerException e) {
                LOGGER.error(String.valueOf(e));
                this.getConfig().setParticle("minecraft:white_ash");
            }
            ++i;
        }
    }
}

