/*
 * Decompiled with CFR 0.152.
 */
package net.lizistired.cavedust;

import java.nio.file.Path;
import net.lizistired.cavedust.CaveDust;
import net.lizistired.cavedust.utils.JsonFile;
import net.lizistired.cavedust.utils.MathHelper;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;

public class CaveDustConfig
extends JsonFile {
    private final transient CaveDust CaveDust;
    private int dimensionMaxX = 5;
    private int dimensionMaxY = 5;
    private int dimensionMaxZ = 5;
    private int dimensionMinX = -5;
    private int dimensionMinY = -5;
    private int dimensionMinZ = -5;
    private int velocityRandomness = 1;
    private boolean caveDustEnabled = true;
    private String particleName = "white_ash";
    private boolean seaLevelCheck = true;
    private boolean superFlatStatus = false;
    private float upperLimit = 64.0f;
    private float lowerLimit = -64.0f;
    private int particleMultiplier = 1;

    public CaveDustConfig(Path file, CaveDust caveDust) {
        super(file);
        this.CaveDust = caveDust;
    }

    public float setDimensionsMinX(float size) {
        if ((float)this.dimensionMinX != size) {
            this.dimensionMinX = (int)size;
            this.save();
        }
        return this.getDimensionsMinX();
    }

    public float setDimensionsMinY(float size) {
        if ((float)this.dimensionMinY != size) {
            this.dimensionMinY = (int)size;
            this.save();
        }
        return this.getDimensionsMinY();
    }

    public float setDimensionsMinZ(float size) {
        if ((float)this.dimensionMinZ != size) {
            this.dimensionMinZ = (int)size;
            this.save();
        }
        return this.getDimensionsMinZ();
    }

    public float getDimensionsMinX() {
        return this.dimensionMinX;
    }

    public float getDimensionsMinY() {
        return this.dimensionMinY;
    }

    public float getDimensionsMinZ() {
        return this.dimensionMinZ;
    }

    public float setDimensionsMaxX(float size) {
        if ((float)this.dimensionMaxX != size) {
            this.dimensionMaxX = (int)size;
            this.save();
        }
        return this.getDimensionsMaxX();
    }

    public float setDimensionsMaxY(float size) {
        if ((float)this.dimensionMaxY != size) {
            this.dimensionMaxY = (int)size;
            this.save();
        }
        return this.getDimensionsMaxY();
    }

    public float setDimensionsMaxZ(float size) {
        if ((float)this.dimensionMaxZ != size) {
            this.dimensionMaxZ = (int)size;
            this.save();
        }
        return this.getDimensionsMaxZ();
    }

    public float getDimensionsMaxX() {
        return this.dimensionMaxX;
    }

    public float getDimensionsMaxY() {
        return this.dimensionMaxY;
    }

    public float getDimensionsMaxZ() {
        return this.dimensionMaxZ;
    }

    public float setUpperLimit(float upperLimit) {
        if (this.upperLimit - 1.0f < this.getLowerLimit()) {
            return this.getUpperLimit();
        }
        if (this.upperLimit != upperLimit) {
            this.upperLimit = (int)upperLimit;
            this.save();
        }
        return this.getUpperLimit();
    }

    public float getUpperLimit() {
        return this.upperLimit;
    }

    public float setLowerLimit(float lowerLimit) {
        if (this.lowerLimit + 1.0f > this.getUpperLimit()) {
            return this.getLowerLimit();
        }
        if (this.lowerLimit != lowerLimit) {
            this.lowerLimit = (int)lowerLimit;
            this.save();
        }
        return this.getLowerLimit();
    }

    public float getLowerLimit() {
        return this.lowerLimit;
    }

    public int getParticleMultiplier() {
        return this.particleMultiplier;
    }

    public float setParticleMultiplier(float particleMultiplier) {
        this.particleMultiplier = (int)particleMultiplier;
        this.save();
        return this.getParticleMultiplier();
    }

    public boolean toggleCaveDust() {
        this.caveDustEnabled = !this.caveDustEnabled;
        this.save();
        return this.caveDustEnabled;
    }

    public boolean getCaveDustEnabled() {
        return this.caveDustEnabled;
    }

    public class_2394 setParticle(String particleType) {
        this.particleName = particleType;
        this.save();
        return this.getParticle();
    }

    public class_2394 getParticle() {
        try {
            return (class_2394)class_2378.field_11141.method_10223(new class_2960(this.particleName.toLowerCase()));
        }
        catch (ClassCastException e) {
            net.lizistired.cavedust.CaveDust.LOGGER.error(e + "\nThere was an error loading the specified particle from the config, make sure a valid particle name is specified. Falling back to \"minecraft:white_ash\".");
            this.particleName = "minecraft:white_ash";
            this.save();
            return class_2398.field_23956;
        }
    }

    public boolean getSeaLevelCheck() {
        return this.seaLevelCheck;
    }

    public boolean setSeaLevelCheck() {
        this.seaLevelCheck = !this.seaLevelCheck;
        this.save();
        return this.getSeaLevelCheck();
    }

    public float getVelocityRandomnessRandom() {
        if (this.velocityRandomness == 0) {
            return 0.0f;
        }
        return (float)MathHelper.generateRandomDouble(-this.velocityRandomness, this.velocityRandomness);
    }

    public float getVelocityRandomness() {
        return this.velocityRandomness;
    }

    public float setVelocityRandomness(float velocityRandomness) {
        this.velocityRandomness = (int)velocityRandomness;
        this.save();
        return this.getVelocityRandomness();
    }

    public boolean getSuperFlatStatus() {
        return this.superFlatStatus;
    }

    public boolean setSuperFlatStatus() {
        this.superFlatStatus = !this.superFlatStatus;
        this.save();
        return this.getSuperFlatStatus();
    }

    public void resetConfig() {
        this.dimensionMinX = -5;
        this.dimensionMinY = -5;
        this.dimensionMinZ = -5;
        this.dimensionMaxX = 5;
        this.dimensionMaxY = 5;
        this.dimensionMaxZ = 5;
        this.upperLimit = 64.0f;
        this.lowerLimit = -64.0f;
        this.particleMultiplier = 1;
        this.seaLevelCheck = true;
        this.caveDustEnabled = true;
        this.particleName = "minecraft:white_ash";
        this.save();
    }
}

