/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.data.EmiRecipeCategoryProperties;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.registry.EmiRecipeFiller;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_465;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;

public class EmiUtil {
    public static final Random RANDOM = new Random();

    public static String subId(class_2960 id) {
        return id.method_12836() + "/" + id.method_12832();
    }

    public static String subId(class_2248 block) {
        return EmiUtil.subId(EmiPort.getBlockRegistry().method_10221((Object)block));
    }

    public static String subId(class_1792 item) {
        return EmiUtil.subId(EmiPort.getItemRegistry().method_10221((Object)item));
    }

    public static String subId(class_3611 fluid) {
        return EmiUtil.subId(EmiPort.getFluidRegistry().method_10221((Object)fluid));
    }

    public static <T> Stream<class_6880<T>> values(class_6862<T> key) {
        class_2378 registry = (class_2378)class_7923.field_41167.method_29107(key.comp_326());
        Optional opt = registry.method_40266(key);
        if (opt.isEmpty()) {
            return Stream.of(new class_6880[0]);
        }
        if (registry == EmiPort.getFluidRegistry()) {
            return ((class_6885.class_6888)opt.get()).method_40239().filter(o -> {
                class_3611 f = (class_3611)o.comp_349();
                return f.method_15793(f.method_15785());
            });
        }
        return ((class_6885.class_6888)opt.get()).method_40239();
    }

    public static boolean showAdvancedTooltips() {
        class_310 client = class_310.method_1551();
        return client.field_1690.field_1827;
    }

    public static String translateId(String prefix, class_2960 id) {
        return prefix + id.method_12836() + "." + id.method_12832().replace('/', '.');
    }

    public static String getModName(String namespace) {
        return EmiAgnos.getModName(namespace);
    }

    public static List<String> getStackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)writer, true));
        return Arrays.asList(writer.getBuffer().toString().split("\n"));
    }

    public static class_1715 getCraftingInventory() {
        return new class_1715(new class_1703(null, -1){

            public boolean method_7597(class_1657 player) {
                return false;
            }

            public class_1799 method_7601(class_1657 player, int index) {
                return class_1799.field_8037;
            }

            public void method_7609(class_1263 inventory) {
            }
        }, 3, 3);
    }

    public static int getOutputCount(EmiRecipe recipe, EmiIngredient stack) {
        int count = 0;
        for (EmiStack o : recipe.getOutputs()) {
            if (!stack.getEmiStacks().contains(o)) continue;
            count = (int)((long)count + o.getAmount());
        }
        return count;
    }

    public static EmiRecipe getPreferredRecipe(EmiIngredient ingredient, EmiPlayerInventory inventory, boolean requireCraftable) {
        if (ingredient.getEmiStacks().size() == 1 && !ingredient.isEmpty()) {
            EmiStack stack = ingredient.getEmiStacks().get(0);
            return EmiUtil.getPreferredRecipe(EmiApi.getRecipeManager().getRecipesByOutput(stack), inventory, requireCraftable);
        }
        return null;
    }

    public static EmiRecipe getPreferredRecipe(List<EmiRecipe> recipes, EmiPlayerInventory inventory, boolean requireCraftable) {
        EmiRecipe preferred = null;
        int preferredWeight = -1;
        class_465<?> hs = EmiApi.getHandledScreen();
        EmiCraftContext context = new EmiCraftContext(hs, inventory, EmiCraftContext.Type.CRAFTABLE);
        for (EmiRecipe recipe : recipes) {
            int weight = 0;
            EmiRecipeHandler<?> handler = EmiRecipeFiller.getFirstValidHandler(recipe, hs);
            if (handler != null && handler.canCraft(recipe, context)) {
                weight += 16;
            } else {
                if (requireCraftable) continue;
                if (inventory.canCraft(recipe)) {
                    weight += 8;
                }
            }
            if (BoM.isRecipeEnabled(recipe)) {
                weight += 4;
            }
            if (recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING) {
                weight += 2;
            }
            if (weight > preferredWeight) {
                preferredWeight = weight;
                preferred = recipe;
                continue;
            }
            if (weight != preferredWeight || EmiRecipeCategoryProperties.getOrder(recipe.getCategory()) >= EmiRecipeCategoryProperties.getOrder(preferred.getCategory())) continue;
            preferredWeight = weight;
            preferred = recipe;
        }
        return preferred;
    }

    public static EmiRecipe getRecipeResolution(EmiIngredient ingredient, EmiPlayerInventory inventory) {
        if (ingredient.getEmiStacks().size() == 1 && !ingredient.isEmpty()) {
            EmiStack stack = ingredient.getEmiStacks().get(0);
            return EmiUtil.getPreferredRecipe(EmiApi.getRecipeManager().getRecipesByOutput(stack).stream().filter(r -> r.supportsRecipeTree() && r.getOutputs().stream().anyMatch(i -> i.isEqual(stack))).toList(), inventory, false);
        }
        return null;
    }
}

