/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.VanillaPlugin;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeManager;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.recipe.EmiSyntheticIngredientRecipe;
import dev.emi.emi.recipe.EmiTagRecipe;
import dev.emi.emi.registry.EmiRecipes;
import dev.emi.emi.registry.EmiStackList;
import dev.emi.emi.runtime.EmiFavorite;
import dev.emi.emi.runtime.EmiHistory;
import dev.emi.emi.runtime.EmiSidebars;
import dev.emi.emi.screen.BoMScreen;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.screen.RecipeScreen;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class EmiApi {
    private static final class_310 client = class_310.method_1551();

    public static List<EmiStack> getIndexStacks() {
        return EmiStackList.stacks;
    }

    public static EmiRecipeManager getRecipeManager() {
        return EmiRecipes.manager;
    }

    public static boolean isCheatMode() {
        return EmiConfig.cheatMode;
    }

    public static String getSearchText() {
        return EmiScreenManager.search.method_1882();
    }

    public static void setSearchText(String text) {
        EmiScreenManager.search.method_1852(text);
    }

    public static boolean isSearchFocused() {
        return EmiScreenManager.search.method_25370();
    }

    public static EmiStackInteraction getHoveredStack(int mouseX, int mouseY, boolean includeStandard) {
        return EmiScreenManager.getHoveredStack(mouseX, mouseY, includeStandard);
    }

    public static EmiStackInteraction getHoveredStack(boolean includeStandard) {
        return EmiScreenManager.getHoveredStack(EmiScreenManager.lastMouseX, EmiScreenManager.lastMouseY, includeStandard);
    }

    @ApiStatus.Experimental
    @Nullable
    public static EmiRecipe getRecipeContext(EmiIngredient stack) {
        if (stack instanceof EmiFavorite) {
            EmiFavorite fav = (EmiFavorite)stack;
            return fav.getRecipe();
        }
        return null;
    }

    public static class_465<?> getHandledScreen() {
        class_437 s = EmiApi.client.field_1755;
        if (s instanceof class_465) {
            class_465 hs = (class_465)s;
            return hs;
        }
        if (s instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)s;
            return rs.old;
        }
        if (s instanceof BoMScreen) {
            BoMScreen bs = (BoMScreen)s;
            return bs.old;
        }
        return null;
    }

    public static void displayAllRecipes() {
        EmiRecipeManager manager = EmiApi.getRecipeManager();
        EmiApi.setPages(manager.getCategories().stream().collect(Collectors.toMap(c -> c, c -> manager.getRecipes((EmiRecipeCategory)c))), EmiStack.EMPTY);
    }

    public static void displayRecipeCategory(EmiRecipeCategory category) {
        EmiApi.setPages(Map.of(category, EmiApi.getRecipeManager().getRecipes(category)), EmiStack.EMPTY);
    }

    public static void displayRecipe(EmiRecipe recipe) {
        EmiApi.setPages(Map.of(recipe.getCategory(), List.of(recipe)), EmiStack.EMPTY);
    }

    public static void displayRecipes(EmiIngredient stack) {
        if (stack instanceof EmiFavorite) {
            EmiFavorite fav = (EmiFavorite)stack;
            stack = fav.getStack();
        }
        if (stack instanceof TagEmiIngredient) {
            TagEmiIngredient tag = (TagEmiIngredient)stack;
            for (EmiRecipe recipe : EmiApi.getRecipeManager().getRecipes(VanillaPlugin.TAG)) {
                if (!(recipe instanceof EmiTagRecipe)) continue;
                EmiTagRecipe tr = (EmiTagRecipe)recipe;
                if (!tr.key.equals(tag.key)) continue;
                EmiApi.setPages(Map.of(VanillaPlugin.TAG, List.of(recipe)), stack);
                break;
            }
        } else if (stack instanceof ListEmiIngredient) {
            ListEmiIngredient list = (ListEmiIngredient)stack;
            EmiApi.setPages(Map.of(VanillaPlugin.INGREDIENT, List.of(new EmiSyntheticIngredientRecipe(stack))), stack);
        } else if (stack.getEmiStacks().size() == 1) {
            EmiStack es = stack.getEmiStacks().get(0);
            EmiApi.setPages(EmiApi.mapRecipes(EmiApi.pruneSources(EmiApi.getRecipeManager().getRecipesByOutput(es), es)), stack);
            EmiApi.focusRecipe(BoM.getRecipe(es));
        }
    }

    public static void displayUses(EmiIngredient stack) {
        if (!stack.isEmpty()) {
            EmiStack zero = stack.getEmiStacks().get(0);
            Map<EmiRecipeCategory, List<EmiRecipe>> map = EmiApi.mapRecipes(Stream.concat(EmiApi.pruneUses(EmiApi.getRecipeManager().getRecipesByInput(zero), stack).stream(), EmiRecipes.byWorkstation.getOrDefault(zero, List.of()).stream()).distinct().toList());
            EmiApi.setPages(map, stack);
        }
    }

    public static void viewRecipeTree() {
        class_437 s;
        if (EmiApi.client.field_1755 == null) {
            client.method_1507((class_437)new class_490((class_1657)EmiApi.client.field_1724));
        }
        if ((s = EmiApi.client.field_1755) instanceof class_465) {
            class_465 hs = (class_465)s;
            EmiApi.push();
            client.method_1507((class_437)new BoMScreen(hs));
        } else if (s instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)s;
            EmiApi.push();
            client.method_1507((class_437)new BoMScreen(rs.old));
        }
    }

    public static void focusRecipe(EmiRecipe recipe) {
        class_437 class_4372 = EmiApi.client.field_1755;
        if (class_4372 instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)class_4372;
            rs.focusRecipe(recipe);
        }
    }

    private static void push() {
        class_437 class_4372 = EmiApi.client.field_1755;
        if (class_4372 instanceof RecipeScreen) {
            RecipeScreen rs = (RecipeScreen)class_4372;
            EmiHistory.push(rs);
        } else {
            class_4372 = EmiApi.client.field_1755;
            if (class_4372 instanceof BoMScreen) {
                BoMScreen bs = (BoMScreen)class_4372;
                EmiHistory.push(bs);
            } else {
                EmiHistory.clear();
            }
        }
    }

    private static List<EmiRecipe> pruneSources(List<EmiRecipe> list, EmiStack context) {
        return list.stream().filter(r -> r.getOutputs().stream().anyMatch(i -> i.isEqual(context))).toList();
    }

    private static List<EmiRecipe> pruneUses(List<EmiRecipe> list, EmiIngredient context) {
        return list.stream().filter(r -> r.getInputs().stream().anyMatch(i -> EmiApi.containsAll(i, context)) || r.getCatalysts().stream().anyMatch(i -> EmiApi.containsAll(i, context))).sorted((a, b) -> EmiApi.getSmallestPresence(a, context) - EmiApi.getSmallestPresence(b, context)).toList();
    }

    private static int getSmallestPresence(EmiRecipe recipe, EmiIngredient context) {
        int ideal = context.getEmiStacks().size();
        int smallestPresence = Integer.MAX_VALUE;
        for (EmiIngredient i : recipe.getInputs()) {
            if (EmiApi.containsAll(i, context) && (smallestPresence = Math.min(smallestPresence, i.getEmiStacks().size())) <= ideal) break;
        }
        return smallestPresence;
    }

    private static Map<EmiRecipeCategory, List<EmiRecipe>> mapRecipes(List<EmiRecipe> list) {
        HashMap map = Maps.newHashMap();
        for (EmiRecipe recipe : list) {
            map.computeIfAbsent(recipe.getCategory(), k -> Lists.newArrayList()).add(recipe);
        }
        return map;
    }

    private static boolean containsAll(EmiIngredient collection, EmiIngredient ingredient) {
        block0: for (EmiStack ing : ingredient.getEmiStacks()) {
            for (EmiStack col : collection.getEmiStacks()) {
                if (!col.isEqual(ing)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    private static void setPages(Map<EmiRecipeCategory, List<EmiRecipe>> recipes, EmiIngredient stack) {
        if (!(recipes = recipes.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(e -> (EmiRecipeCategory)e.getKey(), e -> (List)e.getValue()))).isEmpty()) {
            class_437 class_4372;
            EmiSidebars.lookup(stack);
            if (EmiApi.getHandledScreen() == null) {
                client.method_1507((class_437)new class_490((class_1657)EmiApi.client.field_1724));
            }
            if ((class_4372 = EmiApi.client.field_1755) instanceof class_465) {
                class_465 hs = (class_465)class_4372;
                EmiApi.push();
                client.method_1507((class_437)new RecipeScreen(hs, recipes));
            } else {
                class_4372 = EmiApi.client.field_1755;
                if (class_4372 instanceof BoMScreen) {
                    BoMScreen bs = (BoMScreen)class_4372;
                    EmiApi.push();
                    client.method_1507((class_437)new RecipeScreen(bs.old, recipes));
                } else {
                    class_4372 = EmiApi.client.field_1755;
                    if (class_4372 instanceof RecipeScreen) {
                        RecipeScreen rs = (RecipeScreen)class_4372;
                        EmiApi.push();
                        RecipeScreen n = new RecipeScreen(rs.old, recipes);
                        client.method_1507((class_437)n);
                        n.focusCategory(rs.getFocusedCategory());
                    }
                }
            }
        }
    }
}

