/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.api.stack;

import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiLog;
import net.minecraft.class_2487;

public class Comparison {
    private static final Comparison COMPARE_NBT = Comparison.of((a, b) -> {
        class_2487 an = a.getNbt();
        class_2487 bn = b.getNbt();
        if (an == null || bn == null) {
            return an == bn;
        }
        return an.equals((Object)bn);
    });
    public static final Comparison DEFAULT_COMPARISON = Comparison.of((a, b) -> true);
    private Predicate predicate;

    private Comparison(Predicate comparator) {
        this.predicate = comparator;
    }

    public static Comparison of(Predicate comparator) {
        return new Comparison(comparator);
    }

    public static Comparison compareNbt() {
        return COMPARE_NBT;
    }

    public boolean compare(EmiStack a, EmiStack b) {
        try {
            return this.predicate.test(a, b);
        }
        catch (Throwable t) {
            this.predicate = (na, nb) -> true;
            EmiLog.error("Comparison threw an exception, disabling");
            t.printStackTrace();
            return true;
        }
    }

    public static interface Predicate {
        public boolean test(EmiStack var1, EmiStack var2);
    }

    static class Builder {
        Builder() {
        }
    }
}

