/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.jemi.JemiCategory;
import dev.emi.emi.jemi.JemiRecipe;
import dev.emi.emi.jemi.JemiRecipeHandler;
import dev.emi.emi.jemi.JemiStack;
import dev.emi.emi.jemi.JemiStackSerializer;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.jemi.runtime.JemiBookmarkOverlay;
import dev.emi.emi.jemi.runtime.JemiDragDropHandler;
import dev.emi.emi.jemi.runtime.JemiIngredientFilter;
import dev.emi.emi.jemi.runtime.JemiIngredientListOverlay;
import dev.emi.emi.jemi.runtime.JemiRecipesGui;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.registry.EmiPluginContainer;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.emi.emi.registry.EmiRecipes;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.runtime.EmiReloadManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRuntimeRegistration;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;

@JeiPlugin
public class JemiPlugin
implements IModPlugin,
EmiPlugin {
    private static final Map<EmiRecipeCategory, IRecipeCategory<?>> CATEGORY_MAP = Maps.newHashMap();
    private static ISubtypeManager subtypeManager;
    public static IJeiRuntime runtime;

    public class_2960 getPluginUid() {
        return new class_2960("emi:jemi");
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        subtypeManager = registration.getSubtypeManager();
    }

    public void registerRuntime(IRuntimeRegistration registration) {
        registration.setIngredientListOverlay((IIngredientListOverlay)new JemiIngredientListOverlay());
        registration.setBookmarkOverlay((IBookmarkOverlay)new JemiBookmarkOverlay());
        registration.setRecipesGui((IRecipesGui)new JemiRecipesGui());
        registration.setIngredientFilter((IIngredientFilter)new JemiIngredientFilter());
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        JemiPlugin.runtime = runtime;
    }

    public void onRuntimeUnavailable() {
        runtime = null;
    }

    @Override
    public void register(EmiRegistry registry) {
        EmiLog.info("[JEMI] Waiting for JEI to finish reloading...");
        EmiReloadManager.step((class_2561)EmiPort.literal("Waiting for JEI to finish..."), 20000L);
        try {
            while (runtime == null) {
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            return;
        }
        EmiLog.info("[JEMI] JEI reloaded!");
        Set handledNamespaces = EmiAgnos.getPlugins().stream().map(EmiPluginContainer::id).collect(Collectors.toSet());
        EmiReloadManager.step((class_2561)EmiPort.literal("Loading information from JEI..."), 5000L);
        registry.addGenericExclusionArea((screen, consumer) -> {
            if (runtime != null && runtime.getScreenHelper() != null) {
                List areas = runtime.getScreenHelper().getGuiExclusionAreas(screen).toList();
                for (class_768 r : areas) {
                    if (r == null) continue;
                    consumer.accept(new Bounds(r.method_3321(), r.method_3322(), r.method_3319(), r.method_3320()));
                }
            }
        });
        registry.addGenericStackProvider((screen, x, y) -> new EmiStackInteraction(runtime.getScreenHelper().getClickableIngredientUnderMouse(screen, (double)x, (double)y).map(IClickableIngredient::getTypedIngredient).map(JemiUtil::getStack).findFirst().orElse(EmiStack.EMPTY), null, false));
        registry.addGenericDragDropHandler(new JemiDragDropHandler());
        registry.addIngredientSerializer(JemiStack.class, new JemiStackSerializer(runtime.getIngredientManager()));
        EmiReloadManager.step((class_2561)EmiPort.literal("Processing JEI stacks..."), 5000L);
        for (IIngredientType type : runtime.getIngredientManager().getRegisteredIngredientTypes()) {
            if (type == JemiUtil.getFluidType() || type == VanillaTypes.ITEM_STACK) continue;
            for (Object o : runtime.getIngredientManager().getAllIngredients(type)) {
                EmiStack stack = JemiUtil.getStack(type, o);
                if (stack.isEmpty()) continue;
                registry.addEmiStack(stack);
            }
        }
        registry.removeEmiStacks(s -> {
            try {
                Optional<ITypedIngredient<?>> opt = JemiUtil.getTyped(s);
                if (opt.isPresent()) {
                    return !runtime.getIngredientVisibility().isIngredientVisible(opt.get());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        });
        EmiReloadManager.step((class_2561)EmiPort.literal("Processing JEI recipes..."), 5000L);
        Set existingCategories = EmiRecipes.categories.stream().map(EmiRecipeCategory::getId).collect(Collectors.toSet());
        HashMap categoryMap = Maps.newHashMap();
        categoryMap.put(RecipeTypes.CRAFTING, VanillaEmiRecipeCategories.CRAFTING);
        categoryMap.put(RecipeTypes.SMELTING, VanillaEmiRecipeCategories.SMELTING);
        categoryMap.put(RecipeTypes.BLASTING, VanillaEmiRecipeCategories.BLASTING);
        categoryMap.put(RecipeTypes.SMOKING, VanillaEmiRecipeCategories.SMOKING);
        categoryMap.put(RecipeTypes.CAMPFIRE_COOKING, VanillaEmiRecipeCategories.CAMPFIRE_COOKING);
        categoryMap.put(RecipeTypes.STONECUTTING, VanillaEmiRecipeCategories.STONECUTTING);
        categoryMap.put(RecipeTypes.SMITHING, VanillaEmiRecipeCategories.SMITHING);
        categoryMap.put(RecipeTypes.ANVIL, VanillaEmiRecipeCategories.ANVIL_REPAIRING);
        categoryMap.put(RecipeTypes.BREWING, VanillaEmiRecipeCategories.BREWING);
        categoryMap.put(RecipeTypes.FUELING, VanillaEmiRecipeCategories.FUEL);
        categoryMap.put(RecipeTypes.COMPOSTING, VanillaEmiRecipeCategories.COMPOSTING);
        categoryMap.put(RecipeTypes.INFORMATION, VanillaEmiRecipeCategories.INFO);
        CATEGORY_MAP.clear();
        EmiRecipeFiller.extraHandlers = JemiPlugin::getRecipeHandler;
        List categories = runtime.getRecipeManager().createRecipeCategoryLookup().includeHidden().get().toList();
        for (IRecipeCategory c : categories) {
            EmiLog.info("[JEMI] Collecing data for " + c.getTitle().getString());
            EmiReloadManager.step((class_2561)EmiPort.literal("Loading JEI data for ").method_10852(c.getTitle()), 5000L);
            try {
                EmiRecipeCategory category;
                RecipeType type = c.getRecipeType();
                class_2960 id = type.getUid();
                List<EmiStack> catalysts = runtime.getRecipeManager().createRecipeCatalystLookup(type).includeHidden().get().map(JemiUtil::getStack).toList();
                if (categoryMap.containsKey(type)) {
                    category = (EmiRecipeCategory)categoryMap.get(type);
                    CATEGORY_MAP.put(category, c);
                    for (EmiStack catalyst : catalysts) {
                        if (catalyst.isEmpty()) continue;
                        registry.addWorkstation(category, catalyst);
                    }
                    if (type != RecipeTypes.INFORMATION) continue;
                    this.addInfoRecipes(registry, (IRecipeCategory<IJeiIngredientInfoRecipe>)c);
                    continue;
                }
                if (handledNamespaces.contains(id.method_12836())) {
                    EmiLog.info("[JEMI] Skipping recipe category " + id + " because mod is already handled");
                    continue;
                }
                if (existingCategories.contains(id)) {
                    EmiLog.info("[JEMI] Skipping recipe category " + id + " because native EMI recipe category already exists");
                    continue;
                }
                category = new JemiCategory(c);
                CATEGORY_MAP.put(category, c);
                registry.addCategory(category);
                for (EmiStack catalyst : catalysts) {
                    if (catalyst.isEmpty()) continue;
                    registry.addWorkstation(category, catalyst);
                }
                List recipes = runtime.getRecipeManager().createRecipeLookup(type).includeHidden().get().toList();
                for (Object r : recipes) {
                    try {
                        registry.addRecipe(new JemiRecipe(category, c, r));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        EmiReloadManager.step((class_2561)EmiPort.literal("Processing JEI subtypes..."), 5000L);
        JemiPlugin.safely("subtype comparison", () -> this.parseSubtypes(registry));
    }

    private void addInfoRecipes(EmiRegistry registry, IRecipeCategory<IJeiIngredientInfoRecipe> category) {
        List recipes = runtime.getRecipeManager().createRecipeLookup(RecipeTypes.INFORMATION).includeHidden().get().toList();
        HashMap grouped = Maps.newHashMap();
        for (IJeiIngredientInfoRecipe recipe : recipes) {
            grouped.computeIfAbsent(recipe.getIngredients().stream().map(JemiUtil::getStack).toList(), k -> Lists.newArrayList()).add(recipe);
        }
        HashMap identical = Maps.newHashMap();
        for (Map.Entry group : grouped.entrySet()) {
            class_5250 text = EmiPort.literal("");
            for (IJeiIngredientInfoRecipe recipe : (List)group.getValue()) {
                for (class_5348 sv : recipe.getDescription()) {
                    class_5250 current = EmiPort.literal("");
                    sv.method_27658((style, string) -> {
                        current.method_10852((class_2561)EmiPort.literal(string, style));
                        return Optional.empty();
                    }, class_2583.field_24360);
                    if (current.getString().isBlank()) continue;
                    if (!text.getString().isEmpty()) {
                        text.method_27693(" ");
                    }
                    text.method_10852((class_2561)current);
                }
            }
            identical.computeIfAbsent(text, k -> Lists.newArrayList()).addAll((Collection)group.getKey());
        }
        for (class_2561 text : identical.keySet()) {
            registry.addRecipe(new EmiInfoRecipe(((List)identical.get(text)).stream().map(s -> s).toList(), List.of(text), null));
        }
    }

    private void parseSubtypes(EmiRegistry registry) {
        if (subtypeManager != null) {
            IIngredientManager im = runtime.getIngredientManager();
            ArrayList types = Lists.newArrayList((Iterable)im.getRegisteredIngredientTypes());
            for (IIngredientType type : types) {
                if (!(type instanceof IIngredientTypeWithSubtypes)) continue;
                IIngredientTypeWithSubtypes iitws = (IIngredientTypeWithSubtypes)type;
                ArrayList ings = Lists.newArrayList((Iterable)im.getAllIngredients(type));
                for (Object o : ings) {
                    try {
                        String info = subtypeManager.getSubtypeInfo(iitws, o, UidContext.Recipe);
                        if (info == "") continue;
                        if (type == VanillaTypes.ITEM_STACK) {
                            registry.setDefaultComparison(iitws.getBase(o), Comparison.of((a, b) -> subtypeManager.getSubtypeInfo(a.getItemStack(), UidContext.Recipe).equals(subtypeManager.getSubtypeInfo(b.getItemStack(), UidContext.Recipe))));
                            continue;
                        }
                        if (type == JemiUtil.getFluidType()) {
                            registry.setDefaultComparison(iitws.getBase(o), Comparison.of((a, b) -> {
                                ITypedIngredient ta = JemiUtil.getTyped(a).orElse(null);
                                ITypedIngredient tb = JemiUtil.getTyped(b).orElse(null);
                                if (ta != null && tb != null) {
                                    return subtypeManager.getSubtypeInfo(iitws, ta.getIngredient(), UidContext.Recipe).equals(subtypeManager.getSubtypeInfo(iitws, tb.getIngredient(), UidContext.Recipe));
                                }
                                return false;
                            }));
                            continue;
                        }
                        registry.setDefaultComparison(iitws.getBase(o), Comparison.of((a, b) -> {
                            if (a instanceof JemiStack) {
                                JemiStack ja = (JemiStack)a;
                                if (b instanceof JemiStack) {
                                    JemiStack jb = (JemiStack)b;
                                    return subtypeManager.getSubtypeInfo(iitws, ja.ingredient, UidContext.Recipe).equals(subtypeManager.getSubtypeInfo(iitws, jb.ingredient, UidContext.Recipe));
                                }
                            }
                            return false;
                        }));
                    }
                    catch (Throwable t) {
                        EmiReloadLog.warn("Exception adding default comparison for JEI ingredient");
                        EmiReloadLog.error(t);
                    }
                }
            }
        }
    }

    private static EmiRecipeHandler<?> getRecipeHandler(class_1703 handler, EmiRecipe recipe) {
        IRecipeCategory category = CATEGORY_MAP.getOrDefault(recipe.getCategory(), null);
        if (category != null) {
            return runtime.getRecipeTransferManager().getRecipeTransferHandler(handler, category).map(JemiRecipeHandler::new).orElse(null);
        }
        return null;
    }

    private static void safely(String name, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            EmiReloadLog.warn("Exception thrown when reloading " + name + " step in JEMI plugin");
            EmiReloadLog.error(t);
        }
    }
}

