/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.config.FluidUnit;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1874;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class EmiCookingRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final EmiRecipeCategory category;
    private final EmiIngredient input;
    private final EmiStack output;
    private final class_1874 recipe;
    private final int fuelMultiplier;
    private final boolean infiniBurn;

    public EmiCookingRecipe(class_1874 recipe, EmiRecipeCategory category, int fuelMultiplier, boolean infiniBurn) {
        this.id = recipe.method_8114();
        this.category = category;
        this.input = EmiIngredient.of((class_1856)recipe.method_8117().get(0));
        this.output = EmiStack.of(EmiPort.getOutput(recipe));
        if (this.input.getEmiStacks().get(0).getItemStack().method_31574(class_1802.field_8554)) {
            this.input.getEmiStacks().get(0).setRemainder(EmiStack.of((class_3611)class_3612.field_15910, (long)FluidUnit.BUCKET));
        }
        this.recipe = recipe;
        this.fuelMultiplier = fuelMultiplier;
        this.infiniBurn = infiniBurn;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    @Override
    public int getDisplayWidth() {
        return 82;
    }

    @Override
    public int getDisplayHeight() {
        return 38;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addFillingArrow(24, 5, 50 * this.recipe.method_8167()).tooltip((mx, my) -> List.of(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable("emi.cooking.time", Float.valueOf((float)this.recipe.method_8167() / 20.0f))))));
        if (this.infiniBurn) {
            widgets.addTexture(EmiTexture.FULL_FLAME, 1, 24);
        } else {
            widgets.addTexture(EmiTexture.EMPTY_FLAME, 1, 24);
            widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 1, 24, 4000 / this.fuelMultiplier, false, true, true);
        }
        widgets.addText(EmiPort.ordered((class_2561)EmiPort.translatable("emi.cooking.experience", Float.valueOf(this.recipe.method_8171()))), 26, 28, -1, true);
        widgets.addSlot(this.input, 0, 4);
        widgets.addSlot(this.output, 56, 0).large(true).recipeContext(this);
    }
}

