/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeManager;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.EmiData;
import dev.emi.emi.data.EmiRecipeCategoryProperties;
import dev.emi.emi.registry.EmiRecipeSorter;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class EmiRecipes {
    public static EmiRecipeManager manager = Manager.EMPTY;
    public static List<Consumer<Consumer<EmiRecipe>>> lateRecipes = Lists.newArrayList();
    public static List<Predicate<EmiRecipe>> invalidators = Lists.newArrayList();
    public static List<EmiRecipeCategory> categories = Lists.newArrayList();
    private static Map<EmiRecipeCategory, List<EmiIngredient>> workstations = Maps.newHashMap();
    private static List<EmiRecipe> recipes = Lists.newArrayList();
    public static Map<EmiStack, List<EmiRecipe>> byWorkstation = Maps.newHashMap();

    public static void clear() {
        lateRecipes.clear();
        invalidators.clear();
        categories.clear();
        workstations.clear();
        recipes.clear();
        byWorkstation.clear();
        manager = Manager.EMPTY;
    }

    public static void bake() {
        long start = System.currentTimeMillis();
        recipes.addAll(EmiData.recipes.stream().map(r -> (EmiRecipe)r.get()).toList());
        categories.sort((a, b) -> EmiRecipeCategoryProperties.getOrder(a) - EmiRecipeCategoryProperties.getOrder(b));
        invalidators.addAll(EmiData.recipeFilters);
        invalidators.add(r -> {
            for (EmiIngredient i : Iterables.concat(r.getInputs(), r.getOutputs(), r.getCatalysts())) {
                if (!EmiHidden.isDisabled(i)) continue;
                return true;
            }
            return false;
        });
        List<EmiRecipe> filtered = recipes.stream().filter(r -> {
            for (Predicate<EmiRecipe> predicate : invalidators) {
                if (!predicate.test((EmiRecipe)r)) continue;
                return false;
            }
            return true;
        }).toList();
        manager = new Manager(categories, workstations, filtered);
        EmiLog.info("Baked " + recipes.size() + " recipes in " + (System.currentTimeMillis() - start) + "ms");
    }

    public static void addCategory(EmiRecipeCategory category) {
        categories.add(category);
    }

    public static void addWorkstation(EmiRecipeCategory category, EmiIngredient workstation) {
        workstations.computeIfAbsent(category, k -> Lists.newArrayList()).add(workstation);
    }

    public static void addRecipe(EmiRecipe recipe) {
        recipes.add(recipe);
    }

    private static class Manager
    implements EmiRecipeManager {
        public static final EmiRecipeManager EMPTY = new Manager();
        private final List<EmiRecipeCategory> categories;
        private final Map<EmiRecipeCategory, List<EmiIngredient>> workstations;
        private final List<EmiRecipe> recipes;
        private Map<EmiStack, List<EmiRecipe>> byInput = Maps.newHashMap();
        private Map<EmiStack, List<EmiRecipe>> byOutput = Maps.newHashMap();
        private Map<EmiRecipeCategory, List<EmiRecipe>> byCategory = Maps.newHashMap();
        private Map<class_2960, EmiRecipe> byId = Maps.newHashMap();

        private Manager() {
            this.categories = List.of();
            this.workstations = Map.of();
            this.recipes = List.of();
        }

        public Manager(List<EmiRecipeCategory> categories, Map<EmiRecipeCategory, List<EmiIngredient>> workstations, List<EmiRecipe> recipes) {
            this.categories = categories.stream().distinct().toList();
            this.workstations = workstations;
            this.recipes = List.copyOf(recipes);
            Object2IntOpenHashMap duplicateIds = new Object2IntOpenHashMap();
            for (EmiRecipe recipe : recipes) {
                class_2960 id = recipe.getId();
                EmiRecipeCategory emiRecipeCategory = recipe.getCategory();
                if (!categories.contains(emiRecipeCategory)) {
                    EmiReloadLog.warn("Recipe " + id + " loaded with unregistered category: " + emiRecipeCategory.getId());
                }
                if (EmiConfig.logNonTagIngredients && recipe.supportsRecipeTree()) {
                    ObjectArraySet seen = new ObjectArraySet(0);
                    for (EmiIngredient ingredient : recipe.getInputs()) {
                        if (!(ingredient instanceof ListEmiIngredient) || seen.contains(ingredient)) continue;
                        EmiReloadLog.warn("Recipe " + recipe.getId() + " uses non-tag ingredient: " + ingredient);
                        seen.add(ingredient);
                    }
                }
                this.byCategory.computeIfAbsent(emiRecipeCategory, a -> Lists.newArrayList()).add(recipe);
                if (id == null) continue;
                if (this.byId.containsKey(id)) {
                    duplicateIds.put((Object)id, duplicateIds.getOrDefault((Object)id, 1) + 1);
                }
                this.byId.put(id, recipe);
            }
            for (class_2960 id : duplicateIds.keySet()) {
                EmiReloadLog.warn(duplicateIds.getInt((Object)id) + " recipes loaded with the same id: " + id);
            }
            HashMap byInput = Maps.newHashMap();
            HashMap byOutput = Maps.newHashMap();
            for (EmiRecipeCategory emiRecipeCategory : this.byCategory.keySet()) {
                String key = EmiUtil.translateId("emi.category.", emiRecipeCategory.getId());
                if (emiRecipeCategory.getName().equals(EmiPort.translatable(key)) && !class_1074.method_4663((String)key)) {
                    EmiReloadLog.warn("Untranslated recipe category " + emiRecipeCategory.getId());
                }
                List<EmiRecipe> cRecipes = this.byCategory.get(emiRecipeCategory);
                Comparator<EmiRecipe> sort = EmiRecipeCategoryProperties.getSort(emiRecipeCategory);
                if (sort != EmiRecipeSorting.none()) {
                    cRecipes = cRecipes.stream().sorted(sort).collect(Collectors.toList());
                    EmiRecipeSorter.clear();
                }
                this.byCategory.put(emiRecipeCategory, cRecipes);
                for (EmiRecipe recipe : cRecipes) {
                    recipe.getInputs().stream().flatMap(i -> i.getEmiStacks().stream()).forEach(i -> byInput.computeIfAbsent(i.copy(), b -> Sets.newLinkedHashSet()).add(recipe));
                    recipe.getCatalysts().stream().flatMap(i -> i.getEmiStacks().stream()).forEach(i -> byInput.computeIfAbsent(i.copy(), b -> Sets.newLinkedHashSet()).add(recipe));
                    recipe.getOutputs().stream().forEach(i -> byOutput.computeIfAbsent(i.copy(), b -> Sets.newLinkedHashSet()).add(recipe));
                }
            }
            for (EmiStack emiStack : byInput.keySet()) {
                this.byInput.put(emiStack, ((Set)byInput.get(emiStack)).stream().toList());
            }
            for (EmiStack emiStack : byOutput.keySet()) {
                this.byOutput.put(emiStack, ((Set)byOutput.get(emiStack)).stream().toList());
            }
            for (EmiRecipeCategory emiRecipeCategory : workstations.keySet()) {
                workstations.put(emiRecipeCategory, workstations.get(emiRecipeCategory).stream().distinct().toList());
            }
            for (Map.Entry entry : this.byCategory.entrySet()) {
                for (EmiIngredient ingredient : workstations.getOrDefault(entry.getKey(), List.of())) {
                    for (EmiStack stack : ingredient.getEmiStacks()) {
                        byWorkstation.computeIfAbsent(stack, s -> Lists.newArrayList()).addAll((Collection)entry.getValue());
                    }
                }
            }
        }

        @Override
        public List<EmiRecipeCategory> getCategories() {
            return this.categories;
        }

        @Override
        public List<EmiIngredient> getWorkstations(EmiRecipeCategory category) {
            return this.workstations.getOrDefault(category, List.of());
        }

        @Override
        public List<EmiRecipe> getRecipes() {
            return this.recipes;
        }

        @Override
        public List<EmiRecipe> getRecipes(EmiRecipeCategory category) {
            return this.byCategory.getOrDefault(category, List.of());
        }

        @Override
        @Nullable
        public EmiRecipe getRecipe(class_2960 id) {
            return this.byId.getOrDefault(id, null);
        }

        @Override
        public List<EmiRecipe> getRecipesByInput(EmiStack stack) {
            return this.byInput.getOrDefault(stack, List.of());
        }

        @Override
        public List<EmiRecipe> getRecipesByOutput(EmiStack stack) {
            return this.byOutput.getOrDefault(stack, List.of());
        }
    }
}

