/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.TagExclusions;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiReloadLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class EmiTags {
    public static final class_2960 HIDDEN_FROM_RECIPE_VIEWERS = new class_2960("c", "hidden_from_recipe_viewers");
    private static final Map<class_6862<?>, class_2960> MODELED_TAGS = Maps.newHashMap();
    private static final Map<Set<?>, List<class_6862<?>>> CACHED_TAGS = Maps.newHashMap();
    private static final Map<class_6862<?>, List<?>> TAG_CONTENTS = Maps.newHashMap();
    private static final Map<class_6862<?>, List<?>> TAG_VALUES = Maps.newHashMap();
    private static final Map<class_2960, List<class_6862<?>>> SORTED_TAGS = Maps.newHashMap();
    public static final List<class_2378<?>> REGISTRIES = List.of(EmiPort.getItemRegistry(), EmiPort.getFluidRegistry());
    public static final List<class_6862<?>> TAGS = Lists.newArrayList();
    public static TagExclusions exclusions = new TagExclusions();

    public static <T> List<EmiStack> getValues(class_6862<T> key) {
        if (TAG_VALUES.containsKey(key)) {
            List values = TAG_VALUES.getOrDefault(key, List.of());
            if (key.comp_326().equals(EmiPort.getItemRegistry().method_30517())) {
                return values.stream().map(t -> EmiStack.of((class_1935)((class_1792)t))).toList();
            }
            if (key.comp_326().equals(EmiPort.getFluidRegistry().method_30517())) {
                return values.stream().map(t -> EmiStack.of((class_3611)t)).toList();
            }
        }
        return List.of();
    }

    public static <T> List<EmiStack> getRawValues(class_6862<T> key) {
        if (key.comp_326().equals(EmiPort.getItemRegistry().method_30517())) {
            return EmiUtil.values(key).map(e -> EmiStack.of((class_1935)((class_1792)e.comp_349()))).toList();
        }
        if (key.comp_326().equals(EmiPort.getFluidRegistry().method_30517())) {
            return EmiUtil.values(key).map(e -> EmiStack.of((class_3611)e.comp_349())).toList();
        }
        if (key.comp_326().equals(EmiPort.getBlockRegistry().method_30517())) {
            return EmiUtil.values(key).map(e -> EmiStack.of((class_1935)((class_2248)e.comp_349()))).toList();
        }
        return List.of();
    }

    public static <T> EmiIngredient getIngredient(Class<T> clazz, List<EmiStack> stacks, long amount) {
        class_2378<class_1792> registry;
        if (clazz == class_1792.class) {
            registry = EmiPort.getItemRegistry();
        } else if (clazz == class_3611.class) {
            registry = EmiPort.getFluidRegistry();
        } else {
            return EmiStack.EMPTY;
        }
        HashMap map = Maps.newHashMap();
        for (EmiStack emiStack : stacks) {
            if (emiStack.isEmpty()) continue;
            map.put(emiStack.getKey(), emiStack);
        }
        if (map.size() == 0) {
            return EmiStack.EMPTY;
        }
        if (map.size() == 1) {
            return ((EmiStack)map.values().stream().toList().get(0)).copy().setAmount(amount);
        }
        ArrayList keys = CACHED_TAGS.get(map.keySet());
        if (keys != null) {
            for (class_6862<?> key : keys) {
                List<?> values = TAG_CONTENTS.get(key);
                map.keySet().removeAll(values);
            }
        } else {
            keys = Lists.newArrayList();
            HashSet hashSet = new HashSet(map.keySet());
            for (class_6862<class_1792> key : EmiTags.getTags(registry)) {
                List<?> values = TAG_CONTENTS.get(key);
                if (values.size() < 2) continue;
                if (map.keySet().containsAll(values)) {
                    map.keySet().removeAll(values);
                    keys.add(key);
                }
                if (!map.isEmpty()) continue;
                break;
            }
            CACHED_TAGS.put(hashSet, keys);
        }
        if (keys == null || keys.isEmpty()) {
            return new ListEmiIngredient(stacks.stream().toList(), amount);
        }
        if (map.isEmpty()) {
            if (keys.size() == 1) {
                return new TagEmiIngredient((class_6862)keys.get(0), amount);
            }
            return new ListEmiIngredient(keys.stream().map(k -> new TagEmiIngredient((class_6862<?>)k, 1L)).toList(), amount);
        }
        return new ListEmiIngredient(List.of(map.values().stream().map(i -> i.copy().setAmount(1L)).toList(), keys.stream().map(k -> new TagEmiIngredient((class_6862<?>)k, 1L)).toList()).stream().flatMap(a -> a.stream()).toList(), amount);
    }

    public static <T> List<class_6862<T>> getTags(class_2378<T> registry) {
        return SORTED_TAGS.get(registry.method_30517().method_29177());
    }

    public static class_2561 getTagName(class_6862<?> key) {
        String s = EmiTags.getTagTranslationKey(key);
        if (s == null) {
            return EmiPort.literal("#" + key.comp_327());
        }
        return EmiPort.translatable(s);
    }

    public static boolean hasTranslation(class_6862<?> key) {
        return EmiTags.getTagTranslationKey(key) != null;
    }

    @Nullable
    private static String getTagTranslationKey(class_6862<?> key) {
        String s;
        class_2960 registry = key.comp_326().method_29177();
        if (registry.method_12836().equals("minecraft") && (s = EmiTags.translatePrefix("tag." + registry.method_12832() + ".", key.comp_327())) != null) {
            return s;
        }
        return EmiTags.translatePrefix("tag.", key.comp_327());
    }

    @Nullable
    private static String translatePrefix(String prefix, class_2960 id) {
        String s = EmiUtil.translateId(prefix, id);
        if (class_1074.method_4663((String)s)) {
            return s;
        }
        if (id.method_12836().equals("forge") && class_1074.method_4663((String)(s = EmiUtil.translateId(prefix, new class_2960("c", id.method_12832()))))) {
            return s;
        }
        return null;
    }

    @Nullable
    public static class_2960 getCustomModel(class_6862<?> key) {
        class_2960 rid = key.comp_327();
        if (rid.method_12836().equals("forge") && !MODELED_TAGS.containsKey(key)) {
            key = class_6862.method_40092((class_5321)key.comp_326(), (class_2960)new class_2960("c", rid.method_12832()));
        }
        return MODELED_TAGS.get(key);
    }

    public static boolean hasCustomModel(class_6862<?> key) {
        return EmiTags.getCustomModel(key) != null;
    }

    public static void registerTagModels(class_3300 manager, Consumer<class_2960> consumer) {
        String[] parts;
        String path;
        MODELED_TAGS.clear();
        for (class_2960 id : EmiPort.findResources(manager, "models/tag", s -> s.endsWith(".json"))) {
            path = id.method_12832();
            parts = (path = path.substring(11, path.length() - 5)).split("/");
            if (parts.length <= 1) continue;
            class_6862 key = class_6862.method_40092((class_5321)class_5321.method_29180((class_2960)new class_2960("minecraft", parts[0])), (class_2960)new class_2960(id.method_12836(), path.substring(1 + parts[0].length())));
            class_2960 mid = new class_2960(id.method_12836(), "tag/" + path);
            MODELED_TAGS.put(key, mid);
            consumer.accept(mid);
        }
        for (class_2960 id : EmiPort.findResources(manager, "models/item/tags", s -> s.endsWith(".json"))) {
            path = id.method_12832();
            path = path.substring(0, path.length() - 5);
            parts = path.substring(17).split("/");
            if (!id.method_12836().equals("emi") || parts.length <= 1) continue;
            class_1091 mid = new class_1091(id.method_12836(), path.substring(12), "inventory");
            MODELED_TAGS.put(class_6862.method_40092((class_5321)EmiPort.getItemRegistry().method_30517(), (class_2960)new class_2960(parts[0], path.substring(18 + parts[0].length()))), (class_2960)mid);
            consumer.accept((class_2960)mid);
        }
    }

    public static void reload() {
        TAGS.clear();
        SORTED_TAGS.clear();
        TAG_CONTENTS.clear();
        TAG_VALUES.clear();
        CACHED_TAGS.clear();
        for (class_2378<?> registry : REGISTRIES) {
            EmiTags.reloadTags(registry);
        }
    }

    private static <T> void reloadTags(class_2378<T> registry) {
        Set hidden = EmiUtil.values(class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)HIDDEN_FROM_RECIPE_VIEWERS)).map(class_6880::comp_349).collect(Collectors.toSet());
        class_2960 rid = registry.method_30517().method_29177();
        List<Object> tags = registry.method_40273().filter(key -> !exclusions.contains(rid, key.comp_327()) && !hidden.containsAll(EmiUtil.values(key).map(class_6880::comp_349).toList())).toList();
        EmiTags.logUntranslatedTags(tags);
        tags = EmiTags.consolodateTags(tags);
        for (class_6862 key2 : tags) {
            List<Object> contents = EmiUtil.values(key2).map(i -> i.comp_349()).toList();
            TAG_CONTENTS.put(key2, contents);
            List<Object> values = contents.stream().filter(s -> !EmiHidden.isDisabled(EmiTags.stackFromKey(key2, s))).toList();
            if (values.isEmpty()) {
                TAG_VALUES.put(key2, contents);
                continue;
            }
            TAG_VALUES.put(key2, values);
        }
        TAGS.addAll(tags.stream().sorted((a, b) -> a.toString().compareTo(b.toString())).toList());
        tags = tags.stream().sorted((a, b) -> Long.compare(EmiUtil.values(b).count(), EmiUtil.values(a).count())).toList();
        SORTED_TAGS.put(registry.method_30517().method_29177(), tags);
    }

    private static <T> EmiStack stackFromKey(class_6862<T> key, T t) {
        if (key.comp_326().equals(EmiPort.getItemRegistry().method_30517())) {
            return EmiStack.of((class_1935)((class_1792)t));
        }
        if (key.comp_326().equals(EmiPort.getFluidRegistry().method_30517())) {
            return EmiStack.of((class_3611)t);
        }
        throw new UnsupportedOperationException("Unsupported tag registry " + key);
    }

    private static <T> void logUntranslatedTags(List<class_6862<T>> tags) {
        if (EmiConfig.logUntranslatedTags) {
            ArrayList untranslated = Lists.newArrayList();
            for (Object tag : tags) {
                if (EmiTags.hasTranslation(tag)) continue;
                untranslated.add(tag.comp_327().toString());
            }
            if (!untranslated.isEmpty()) {
                for (Object tag : untranslated.stream().sorted().toList()) {
                    EmiReloadLog.warn("Untranslated tag #" + tag);
                }
                EmiReloadLog.info(" Tag warning can be disabled in the config, EMI docs describe how to add a translation or exclude tags.");
            }
        }
    }

    private static <T> List<class_6862<T>> consolodateTags(List<class_6862<T>> tags) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < tags.size(); ++i) {
            class_6862<T> key = tags.get(i);
            Set values = EmiUtil.values(key).map(class_6880::comp_349).collect(Collectors.toSet());
            class_6862 original = (class_6862)map.get(values);
            if (original != null) {
                map.put(values, EmiTags.betterTag(key, original));
                continue;
            }
            map.put(values, key);
        }
        return map.values().stream().toList();
    }

    private static <T> class_6862<T> betterTag(class_6862<T> a, class_6862<T> b) {
        String bn;
        if (EmiTags.hasTranslation(a) != EmiTags.hasTranslation(b)) {
            return EmiTags.hasTranslation(a) ? a : b;
        }
        if (EmiTags.hasCustomModel(a) != EmiTags.hasCustomModel(b)) {
            return EmiTags.hasCustomModel(a) ? a : b;
        }
        String an = a.comp_327().method_12836();
        if (!an.equals(bn = b.comp_327().method_12836())) {
            if (an.equals("minecraft")) {
                return a;
            }
            if (bn.equals("minecraft")) {
                return b;
            }
            if (an.equals("c")) {
                return a;
            }
            if (bn.equals("c")) {
                return b;
            }
            if (an.equals("fabric")) {
                return EmiAgnos.isModLoaded("forge") ? b : a;
            }
            if (bn.equals("fabric")) {
                return EmiAgnos.isModLoaded("forge") ? a : b;
            }
            if (an.equals("forge")) {
                return EmiAgnos.isModLoaded("forge") ? a : b;
            }
            if (bn.equals("forge")) {
                return EmiAgnos.isModLoaded("forge") ? b : a;
            }
        }
        return a.comp_327().toString().length() <= b.comp_327().toString().length() ? a : b;
    }
}

