/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.curseofcurses;

import de.melanx.curseofcurses.BlacklistHandler;
import de.melanx.curseofcurses.ConfigHandler;
import de.melanx.curseofcurses.api.CurseUtil;
import de.melanx.curseofcurses.data.CursedData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="curseofcurses")
public class CurseOfCurses {
    public static final String MODID = "curseofcurses";
    public static final Logger LOGGER = LogManager.getLogger((String)"curseofcurses");

    public CurseOfCurses() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.COMMONG_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigChange);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        BlacklistHandler.initBlacklist();
        CurseUtil.reloadCurses();
    }

    private void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getModId().equals(MODID)) {
            BlacklistHandler.initBlacklist();
            CurseUtil.reloadCurses();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level level = player.m_20193_();
        if (event.phase == TickEvent.Phase.START && !level.f_46443_ && CursedData.get((ServerLevel)level).getTimes().contains((int)level.m_46468_() % 24000)) {
            LOGGER.info("It's dange now.");
            CurseUtil.applyCursesRandomly(player, (Double)ConfigHandler.curseChance.get(), (Boolean)ConfigHandler.enchantedCurses.get(), (Boolean)ConfigHandler.cursePerItem.get() == false);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.level.m_7654_() != null && event.level == event.level.m_7654_().m_129783_() && event.level.m_46468_() % 24000L == 12000L) {
            CursedData.get((ServerLevel)event.level).generateTimes();
        }
    }

    @SubscribeEvent
    public void onSleep(PlayerWakeUpEvent event) {
        if (!event.getEntity().m_20193_().f_46443_ && ((Boolean)ConfigHandler.curseForSleep.get()).booleanValue()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            CurseUtil.applyCursesRandomly((Player)player, (Double)ConfigHandler.curseForSleepChance.get(), (Boolean)ConfigHandler.enchantedCurses.get());
            int row = (Integer)ConfigHandler.sleepsInARow.get();
            if (row == 1) {
                return;
            }
            CompoundTag nbt = player.getPersistentData();
            int i = 1;
            if (nbt.m_128441_("SleepRow")) {
                i = nbt.m_128451_("SleepRow") + 1;
                nbt.m_128405_("SleepRow", i);
            } else {
                nbt.m_128405_("SleepRow", 1);
            }
            if (i >= (Integer)ConfigHandler.sleepsInARow.get()) {
                nbt.m_128405_("SleepRow", 0);
                CurseUtil.applyCursesRandomly((Player)player, (Double)ConfigHandler.curseForSleepChance.get(), (Boolean)ConfigHandler.enchantedCurses.get());
            }
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        Player newPlayer = event.getEntity();
        CompoundTag newData = newPlayer.getPersistentData();
        Player oldPlayer = event.getOriginal();
        CompoundTag oldData = oldPlayer.getPersistentData();
        if (!((Boolean)ConfigHandler.resetRowOnDeath.get()).booleanValue()) {
            newData.m_128405_("SleepRow", oldData.m_128451_("SleepRow"));
        }
    }
}

