/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.curseofcurses.api;

import de.melanx.curseofcurses.BlacklistHandler;
import de.melanx.curseofcurses.ConfigHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CurseUtil {
    public static final Random RANDOM = new Random();
    private static final List<Enchantment> CURSES = new ArrayList<Enchantment>();
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean canEnchant(Enchantment enchantment, ItemStack stack) {
        return enchantment != null && enchantment.m_6589_() && !CurseUtil.hasEnchantment(enchantment, stack) && enchantment.m_6081_(stack);
    }

    private static boolean hasEnchantment(Enchantment enchantment, ItemStack stack) {
        ListTag enchantments = stack.m_41785_();
        for (int i = 0; i < enchantments.size(); ++i) {
            CompoundTag nbt = enchantments.m_128728_(i);
            String resourceLocation = nbt.m_128461_("id");
            if (!new ResourceLocation(resourceLocation).equals((Object)ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment))) continue;
            return true;
        }
        return false;
    }

    public static void applyCursesRandomly(Player player, double chance) {
        CurseUtil.applyCursesRandomly(player, chance, false, true);
    }

    public static void applyCursesRandomly(Player player, double chance, boolean ignoreEnchantments) {
        CurseUtil.applyCursesRandomly(player, chance, ignoreEnchantments, true);
    }

    public static void applyCursesRandomly(Player player, double chance, boolean ignoreEnchantments, boolean oneItemOnly) {
        Inventory inv = player.m_150109_();
        ArrayList inventory = new ArrayList();
        inventory.addAll(inv.f_35975_);
        inventory.addAll(inv.f_35974_);
        inventory.addAll(inv.f_35976_);
        Collections.shuffle(inventory);
        for (ItemStack stack : inventory) {
            if (stack.m_41619_() || !stack.m_41720_().m_8120_(stack) || stack.m_41793_() && !ignoreEnchantments || !(chance > Math.random())) continue;
            Enchantment curse = Enchantments.f_44971_;
            for (int j = 0; j < (Integer)ConfigHandler.curseAmount.get(); ++j) {
                ArrayList<Enchantment> curses1 = new ArrayList<Enchantment>(CURSES);
                while (!CurseUtil.canEnchant(curse, stack)) {
                    if (curses1.isEmpty()) {
                        curse = null;
                        break;
                    }
                    int index = RANDOM.nextInt(curses1.size());
                    curse = (Enchantment)curses1.get(index);
                    curses1.remove(index);
                }
                if (curse == null) continue;
                stack.m_41663_(curse, curse.m_6586_());
                player.m_5661_((Component)Component.m_237110_((String)"curseofcurses.message", (Object[])new Object[]{stack.m_41786_(), curse.m_44700_(curse.m_6586_())}), false);
                player.m_6330_(SoundEvents.f_12554_, SoundSource.AMBIENT, 0.5f, 0.1f);
            }
            if (curse == null || curse == Enchantments.f_44971_ || !oneItemOnly) continue;
            break;
        }
    }

    public static void reloadCurses() {
        CURSES.clear();
        if (!BlacklistHandler.BLACKLISTED_CURSES.isEmpty()) {
            LOGGER.info("Curses on blacklist: ");
        }
        for (Enchantment enchantment : Registry.f_122825_) {
            if (!enchantment.m_6589_()) continue;
            if (!BlacklistHandler.BLACKLISTED_CURSES.contains(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).toString())) {
                CURSES.add(enchantment);
                continue;
            }
            LOGGER.info(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment).toString());
        }
        LOGGER.info(CURSES.size() + " curses loaded.");
    }
}

