/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.curseofcurses.data;

import de.melanx.curseofcurses.ConfigHandler;
import de.melanx.curseofcurses.CurseOfCurses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class CursedData
extends SavedData {
    private static final String NAME = "curse_of_curses";
    private final List<Integer> possibleTimes = new ArrayList<Integer>();
    private final ServerLevel level;

    public CursedData(ServerLevel level) {
        this.level = level;
        this.generateTimes();
    }

    public static CursedData get(ServerLevel level) {
        DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
        return (CursedData)storage.m_164861_(nbt -> new CursedData(level).load((CompoundTag)nbt), () -> new CursedData(level), NAME);
    }

    public CursedData load(@Nonnull CompoundTag nbt) {
        this.possibleTimes.clear();
        for (Tag tag : nbt.m_128437_("CurseTimes", 10)) {
            int time = ((CompoundTag)tag).m_128451_("Time");
            this.possibleTimes.add(time);
        }
        return this;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        ListTag list = new ListTag();
        for (int time : this.possibleTimes) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("Time", time);
            list.add((Object)tag);
        }
        compound.m_128365_("CurseTimes", (Tag)list);
        return compound;
    }

    public List<Integer> getTimes() {
        return this.possibleTimes;
    }

    public void generateTimes() {
        this.possibleTimes.clear();
        for (int i = 0; i < (Integer)ConfigHandler.dangeTimesPerNight.get(); ++i) {
            this.possibleTimes.add(this.level.f_46441_.m_188503_((Integer)ConfigHandler.curseTimeEnd.get() - (Integer)ConfigHandler.curseTimeStart.get()) + (Integer)ConfigHandler.curseTimeStart.get());
        }
        CurseOfCurses.LOGGER.debug("Changing dange times to " + Arrays.toString(this.possibleTimes.toArray()));
        this.m_77762_();
    }
}

