/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.protoblock;

import com.google.common.collect.Maps;
import fr.shoqapik.protoblock.blocks.ProtoBlock;
import fr.shoqapik.protoblock.blocks.ProtoBlockEntity;
import fr.shoqapik.protoblock.packet.CUpdateProtoBlockPacket;
import fr.shoqapik.protoblock.renderer.ProtoBlockTileEntityRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="protoblockmod")
public class ProtoblockMod {
    public static final List<ProtoBlockEntity> PROTOBLOCKS_ENTITIES = new ArrayList<ProtoBlockEntity>();
    public static final Map<PlayerEntity, ProtoBlockEntity> PLAYERS_PROTOBLOCK = Maps.newHashMap();
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"protoblockmod");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"protoblockmod");
    public static final RegistryObject<Block> PROTOBLOCK = ProtoblockMod.register("protoblock", () -> new ProtoBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150461_bJ).func_200948_a(-1.0f, 3600000.0f).func_222380_e()));
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"protoblockmod");
    public static final RegistryObject<TileEntityType<ProtoBlockEntity>> PROTOBLOCK_ENTITY = ProtoblockMod.register("protoblock", ProtoBlockEntity::new, PROTOBLOCK);
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("protoblockmod", "channel"), () -> "1", "1"::equals, "1"::equals);

    public ProtoblockMod() {
        ProtoblockMod.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
        BLOCKS.register(eventBus);
        TILE_ENTITY_TYPES.register(eventBus);
    }

    @SubscribeEvent
    public void onTeleport(EntityTeleportEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            for (ProtoBlockEntity protoBlockEntity : PROTOBLOCKS_ENTITIES) {
                if (!protoBlockEntity.isInRadius(new BlockPos(event.getTarget().field_72450_a, event.getTarget().field_72448_b, event.getTarget().field_72449_c)) || !protoBlockEntity.isEnabled() || protoBlockEntity.isTeleportation()) continue;
                event.setCanceled(true);
                event.getEntity().func_145747_a((ITextComponent)new StringTextComponent("Teleportation canceled due to protoblock"), event.getEntity().func_110124_au());
            }
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent event) {
        for (ProtoBlockEntity protoBlockEntity : PROTOBLOCKS_ENTITIES) {
            if (!protoBlockEntity.isInRadius(event.getExplosion().getExploder().func_233580_cy_()) || !protoBlockEntity.isEnabled() || protoBlockEntity.isEnvironementalDamages()) continue;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        CompoundNBT tag;
        ProtoBlockEntity protoBlockEntity;
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && PLAYERS_PROTOBLOCK.containsKey(player = (PlayerEntity)event.getEntity()) && !player.field_70170_p.field_72995_K && (protoBlockEntity = PLAYERS_PROTOBLOCK.get(player)).isEnabled() && protoBlockEntity.isBlockItems() && player.func_184614_ca().func_77942_o() && (tag = player.func_184614_ca().func_77978_p()).func_74764_b("protoblock-denied")) {
            event.setCancellationResult(ActionResultType.FAIL);
            event.setCanceled(true);
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            serverPlayerEntity.func_241151_a_((ITextComponent)new StringTextComponent("Item disabled due to a protoblock"), ChatType.GAME_INFO, player.func_110124_au());
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        CompoundNBT tag;
        ProtoBlockEntity protoBlockEntity;
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && PLAYERS_PROTOBLOCK.containsKey(player = (PlayerEntity)event.getEntity()) && !player.field_70170_p.field_72995_K && (protoBlockEntity = PLAYERS_PROTOBLOCK.get(player)).isEnabled() && protoBlockEntity.isBlockItems() && player.func_184614_ca().func_77942_o() && (tag = player.func_184614_ca().func_77978_p()).func_74764_b("protoblock-denied")) {
            event.setCancellationResult(ActionResultType.FAIL);
            event.setCanceled(true);
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            serverPlayerEntity.func_241151_a_((ITextComponent)new StringTextComponent("Item disabled due to a protoblock"), ChatType.GAME_INFO, player.func_110124_au());
        }
    }

    public static void onJoinProtoBlockArea(PlayerEntity player, ProtoBlockEntity protoBlockEntity) {
        if (!protoBlockEntity.getMessage().isEmpty()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(protoBlockEntity.getMessage()), player.func_110124_au());
        }
        player.func_71033_a(GameType.func_77146_a((int)protoBlockEntity.getGamemode()));
    }

    public static void onLeaveProtoBlockArea(PlayerEntity player, ProtoBlockEntity protoBlockEntity) {
        if (!protoBlockEntity.isFlight()) {
            player.field_71075_bZ.field_75101_c = true;
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity playerEntity = (ServerPlayerEntity)player;
                playerEntity.func_71016_p();
            }
        }
        player.func_71033_a(GameType.SURVIVAL);
    }

    public static void updatePlayerInArea(PlayerEntity player, ProtoBlockEntity protoBlockEntity) {
        for (EffectInstance effectInstance : Potion.func_185168_a((String)protoBlockEntity.getPotion()).func_185170_a()) {
            Effect effect = effectInstance.func_188419_a();
            player.func_195064_c(new EffectInstance(effect, 40, 1, false, false));
        }
        boolean changed = false;
        if (!protoBlockEntity.isFlight()) {
            player.field_71075_bZ.field_75100_b = false;
            player.field_71075_bZ.field_75101_c = false;
            changed = true;
        } else if (!player.field_71075_bZ.field_75101_c && player.func_184812_l_()) {
            player.field_71075_bZ.field_75101_c = true;
            changed = true;
        }
        if (player instanceof ServerPlayerEntity && changed) {
            ServerPlayerEntity playerEntity = (ServerPlayerEntity)player;
            playerEntity.func_71016_p();
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        NETWORK.registerMessage(0, CUpdateProtoBlockPacket.class, CUpdateProtoBlockPacket::encode, CUpdateProtoBlockPacket::decode, CUpdateProtoBlockPacket::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)PROTOBLOCK_ENTITY.get()), ProtoBlockTileEntityRenderer::new);
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> block) {
        RegistryObject ret = ProtoblockMod.registerNoItem(name, block);
        ITEMS.register(name, () -> new BlockItem((Block)ret.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
        return ret;
    }

    private static <T extends TileEntity> RegistryObject<TileEntityType<T>> register(String name, Supplier<T> factory, RegistryObject<? extends Block> block) {
        return TILE_ENTITY_TYPES.register(name, () -> TileEntityType.Builder.func_223042_a((Supplier)factory, (Block[])new Block[]{(Block)block.get()}).func_206865_a(null));
    }

    public static void checkProtoblocks() {
        ArrayList<ProtoBlockEntity> toRemove = new ArrayList<ProtoBlockEntity>();
        for (ProtoBlockEntity protoblock : PROTOBLOCKS_ENTITIES) {
            if (protoblock.isEnabled()) continue;
            toRemove.add(protoblock);
        }
        for (ProtoBlockEntity protoblock : toRemove) {
            PROTOBLOCKS_ENTITIES.remove((Object)protoblock);
        }
    }
}

