/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.protoblock.blocks;

import fr.shoqapik.protoblock.blocks.ProtoBlockEntity;
import fr.shoqapik.protoblock.screen.ProtoBlockScreen;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ProtoBlock
extends ContainerBlock {
    protected static final VoxelShape BOTTOM_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);

    public ProtoBlock(AbstractBlock.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        TileEntity tileentity = p_225533_2_.func_175625_s(p_225533_3_);
        if (tileentity instanceof ProtoBlockEntity && p_225533_4_.func_195070_dx()) {
            ProtoBlockEntity protoBlockEntity = (ProtoBlockEntity)tileentity;
            if (p_225533_2_.field_72995_K) {
                this.handleClient(protoBlockEntity);
            } else {
                this.handleServer(protoBlockEntity, (ServerPlayerEntity)p_225533_4_);
            }
            return ActionResultType.func_233537_a_((boolean)p_225533_2_.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(ProtoBlockEntity protoBlockEntity) {
        Minecraft.func_71410_x().func_147108_a((Screen)new ProtoBlockScreen(protoBlockEntity));
    }

    public void handleServer(ProtoBlockEntity protoBlockEntity, ServerPlayerEntity player) {
        SUpdateTileEntityPacket supdatetileentitypacket = protoBlockEntity.func_189518_D_();
        if (supdatetileentitypacket != null) {
            player.field_71135_a.func_147359_a((IPacket)supdatetileentitypacket);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos otherPos, boolean unknownBool) {
        boolean flag;
        if (!world.field_72995_K && (flag = this.isEnabled(world, pos)) != world.func_175640_z(pos)) {
            if (flag) {
                world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            } else {
                this.setEnabled(world, pos, true);
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld serverWorld, BlockPos pos, Random random) {
        if (this.isEnabled((World)serverWorld, pos) && !serverWorld.func_175640_z(pos) && !serverWorld.field_72995_K) {
            this.setEnabled((World)serverWorld, pos, false);
        }
    }

    public boolean isEnabled(World world, BlockPos pos) {
        return this.getProtoEntity(world, pos).isEnabled();
    }

    public void setEnabled(World world, BlockPos pos, boolean enabled) {
        ProtoBlockEntity protoBlockEntity = this.getProtoEntity(world, pos);
        if (protoBlockEntity.isRedstoneControl()) {
            protoBlockEntity.setEnabled(enabled);
            BlockState blockstate = world.func_180495_p(protoBlockEntity.func_174877_v());
            protoBlockEntity.func_70296_d();
            world.func_184138_a(protoBlockEntity.func_174877_v(), blockstate, blockstate, 3);
        }
    }

    public ProtoBlockEntity getProtoEntity(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ProtoBlockEntity) {
            return (ProtoBlockEntity)tileEntity;
        }
        return null;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new ProtoBlockEntity();
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return BOTTOM_AABB;
    }
}

