/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.protoblock.blocks;

import fr.shoqapik.protoblock.ProtoblockMod;
import fr.shoqapik.protoblock.screen.ProtoBlockScreen;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ProtoBlockEntity
extends TileEntity
implements ITickableTileEntity {
    private boolean enabled = false;
    private int radius = 32;
    private int gamemode;
    private String message = "";
    private boolean blockItems = false;
    private boolean environementalDamages = true;
    private boolean teleportation = true;
    private boolean flight = true;
    private boolean redstoneControl = false;
    private String potion = "";
    private int minX = -1;
    private int minZ = -1;
    private int maxX = -1;
    private int maxZ = -1;
    private int ticks = 0;

    public ProtoBlockEntity() {
        super((TileEntityType)ProtoblockMod.PROTOBLOCK_ENTITY.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 256.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public void setEnabled(boolean enabled) {
        if (enabled && !this.isEnabled()) {
            this.playSound(SoundEvents.field_206938_K);
        } else if (this.isEnabled()) {
            this.playSound(SoundEvents.field_206940_M);
        }
        this.enabled = enabled;
    }

    public void playSound(SoundEvent p_205736_1_) {
        this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, p_205736_1_, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("enabled", this.enabled);
        compound.func_74768_a("radius", this.radius);
        compound.func_74768_a("gamemode", this.gamemode);
        compound.func_74778_a("message", this.message);
        compound.func_74757_a("blockItems", this.blockItems);
        compound.func_74757_a("environementalDamages", this.environementalDamages);
        compound.func_74757_a("teleportation", this.teleportation);
        compound.func_74757_a("flight", this.flight);
        compound.func_74757_a("redstoneControl", this.redstoneControl);
        compound.func_74778_a("potionEffect", this.potion);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.enabled = compound.func_74767_n("enabled");
        this.radius = compound.func_74762_e("radius");
        this.gamemode = compound.func_74762_e("gamemode");
        this.message = compound.func_74779_i("message");
        this.blockItems = compound.func_74767_n("blockItems");
        this.environementalDamages = compound.func_74767_n("environementalDamages");
        this.teleportation = compound.func_74767_n("teleportation");
        this.flight = compound.func_74767_n("flight");
        this.redstoneControl = compound.func_74767_n("redstoneControl");
        this.potion = compound.func_74779_i("potionEffect");
        super.func_230337_a_(state, compound);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compoundnbt = this.func_189515_b(new CompoundNBT());
        return new SUpdateTileEntityPacket(this.field_174879_c, 2, compoundnbt);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.func_230337_a_(blockState, pkt.func_148857_g());
        this.updateGui();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateGui() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71462_r instanceof ProtoBlockScreen) {
            ((ProtoBlockScreen)minecraft.field_71462_r).updateGui();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.func_201670_d()) {
            ++this.ticks;
            if (this.ticks >= 20) {
                this.ticks = 0;
                if (this.minX == -1 && this.minZ == -1 && this.maxX == -1 && this.maxZ == -1) {
                    this.calculateArea();
                }
                if (this.isEnabled()) {
                    if (!ProtoblockMod.PROTOBLOCKS_ENTITIES.contains((Object)this)) {
                        ProtoblockMod.PROTOBLOCKS_ENTITIES.add(this);
                    }
                    ProtoblockMod.checkProtoblocks();
                    for (PlayerEntity player : this.field_145850_b.func_217369_A()) {
                        BlockPos pos = player.func_233580_cy_();
                        if (this.isInRadius(pos)) {
                            if (!ProtoblockMod.PLAYERS_PROTOBLOCK.containsKey(player)) {
                                ProtoblockMod.PLAYERS_PROTOBLOCK.put(player, this);
                                ProtoblockMod.onJoinProtoBlockArea(player, this);
                            }
                            ProtoblockMod.updatePlayerInArea(player, this);
                            continue;
                        }
                        if (ProtoblockMod.PLAYERS_PROTOBLOCK.containsKey(player)) {
                            ProtoBlockEntity protoBlockEntity = ProtoblockMod.PLAYERS_PROTOBLOCK.get(player);
                            if (protoBlockEntity.isInRadius(player.func_233580_cy_())) continue;
                            ProtoblockMod.onLeaveProtoBlockArea(player, this);
                            ProtoblockMod.PLAYERS_PROTOBLOCK.remove(player);
                            continue;
                        }
                        System.out.println("called");
                        if (!player.func_184812_l_() || player.field_71075_bZ.field_75101_c) continue;
                        player.field_71075_bZ.field_75101_c = true;
                        if (!(player instanceof ServerPlayerEntity)) continue;
                        ServerPlayerEntity playerEntity = (ServerPlayerEntity)player;
                        playerEntity.func_71016_p();
                    }
                }
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        ProtoblockMod.PROTOBLOCKS_ENTITIES.remove((Object)this);
        ArrayList<PlayerEntity> toRemovePlayers = new ArrayList<PlayerEntity>();
        for (Map.Entry<PlayerEntity, ProtoBlockEntity> entry : ProtoblockMod.PLAYERS_PROTOBLOCK.entrySet()) {
            if (entry.getValue().func_174877_v() != this.func_174877_v()) continue;
            toRemovePlayers.add(entry.getKey());
        }
        for (PlayerEntity toRemove : toRemovePlayers) {
            ProtoblockMod.onLeaveProtoBlockArea(toRemove, this);
            ProtoblockMod.PLAYERS_PROTOBLOCK.remove(toRemove);
        }
    }

    public boolean isInRadius(BlockPos pos) {
        if (pos.func_177958_n() >= this.minX && pos.func_177958_n() <= this.maxX && pos.func_177952_p() >= this.minZ && pos.func_177952_p() <= this.maxZ) {
            return this.isEnabled();
        }
        return false;
    }

    private void calculateArea() {
        int diameter = this.getRadius() / 2;
        int currentX = this.func_174877_v().func_177958_n();
        int currentZ = this.func_174877_v().func_177952_p();
        this.minX = currentX - diameter;
        this.minZ = currentZ - diameter;
        this.maxX = currentX + diameter;
        this.maxZ = currentZ + diameter;
    }

    public boolean func_183000_F() {
        return true;
    }

    public void setRadius(int radius) {
        if (radius > 256) {
            radius = 256;
        }
        if (radius == 0) {
            this.setEnabled(false);
        }
        this.radius = radius;
        this.calculateArea();
    }

    public void setGamemode(int gamemode) {
        if (GameType.func_77146_a((int)gamemode) == null) {
            gamemode = GameType.SURVIVAL.func_77148_a();
        }
        this.gamemode = gamemode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setBlockItems(boolean blockItems) {
        this.blockItems = blockItems;
    }

    public void setEnvironementalDamages(boolean environementalDamages) {
        this.environementalDamages = environementalDamages;
    }

    public void setTeleportation(boolean teleportation) {
        this.teleportation = teleportation;
    }

    public void setFlight(boolean flight) {
        this.flight = flight;
    }

    public void setRedstoneControl(boolean redstoneControl) {
        this.redstoneControl = redstoneControl;
    }

    public void setPotion(ServerPlayerEntity player, String potion) {
        this.potion = potion;
        if (Potion.func_185168_a((String)potion) == Potions.field_185229_a && !potion.isEmpty()) {
            player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "There isn't any potion effect with such name: " + potion), player.func_110124_au());
            this.potion = "";
        }
    }

    public void func_174878_a(BlockPos p_174878_1_) {
        if (this.minX == -1 && this.minZ == -1 && this.maxX == -1 && this.maxZ == -1) {
            this.calculateArea();
        }
        super.func_174878_a(p_174878_1_);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getRadius() {
        return this.radius;
    }

    public int getGamemode() {
        return this.gamemode;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isBlockItems() {
        return this.blockItems;
    }

    public boolean isEnvironementalDamages() {
        return this.environementalDamages;
    }

    public boolean isTeleportation() {
        return this.teleportation;
    }

    public boolean isFlight() {
        return this.flight;
    }

    public boolean isRedstoneControl() {
        return this.redstoneControl;
    }

    public String getPotion() {
        return this.potion;
    }
}

