/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.protoblock.packet;

import fr.shoqapik.protoblock.blocks.ProtoBlockEntity;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class CUpdateProtoBlockPacket {
    private BlockPos pos;
    private boolean enabled;
    private int radius;
    private int gamemode;
    private String message;
    private boolean blockItems;
    private boolean environementalDamages;
    private boolean teleportation;
    private boolean flight;
    private boolean redstoneControl;
    private String potion;

    public CUpdateProtoBlockPacket() {
    }

    public CUpdateProtoBlockPacket(BlockPos pos, boolean enabled, int radius, int gamemode, String message, boolean blockItems, boolean environementalDamages, boolean teleportation, boolean flight, boolean redstoneControl, String potion) {
        this.pos = pos;
        this.enabled = enabled;
        this.radius = radius;
        this.gamemode = gamemode;
        this.message = message;
        this.blockItems = blockItems;
        this.environementalDamages = environementalDamages;
        this.teleportation = teleportation;
        this.flight = flight;
        this.redstoneControl = redstoneControl;
        this.potion = potion;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static CUpdateProtoBlockPacket decode(PacketBuffer packetBuffer) {
        BlockPos pos = packetBuffer.func_179259_c();
        boolean enabled = packetBuffer.readBoolean();
        int radius = packetBuffer.readInt();
        int gamemode = packetBuffer.readInt();
        String message = packetBuffer.func_218666_n();
        boolean blockItems = packetBuffer.readBoolean();
        boolean environementalDamages = packetBuffer.readBoolean();
        boolean teleportation = packetBuffer.readBoolean();
        boolean flight = packetBuffer.readBoolean();
        boolean redstoneControl = packetBuffer.readBoolean();
        String potion = packetBuffer.func_218666_n();
        CUpdateProtoBlockPacket packet = new CUpdateProtoBlockPacket(pos, enabled, radius, gamemode, message, blockItems, environementalDamages, teleportation, flight, redstoneControl, potion);
        return packet;
    }

    public static void encode(CUpdateProtoBlockPacket packet, PacketBuffer packetBuffer) {
        packetBuffer.func_179255_a(packet.pos);
        packetBuffer.writeBoolean(packet.enabled);
        packetBuffer.writeInt(packet.radius);
        packetBuffer.writeInt(packet.gamemode);
        packetBuffer.func_180714_a(packet.message);
        packetBuffer.writeBoolean(packet.blockItems);
        packetBuffer.writeBoolean(packet.environementalDamages);
        packetBuffer.writeBoolean(packet.teleportation);
        packetBuffer.writeBoolean(packet.flight);
        packetBuffer.writeBoolean(packet.redstoneControl);
        packetBuffer.func_180714_a(packet.potion);
    }

    public static void handle(CUpdateProtoBlockPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        if (player == null) {
            return;
        }
        if (!player.func_195070_dx()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("advMode.notAllowed"), Util.field_240973_b_);
        } else {
            TileEntity tileentity = player.field_70170_p.func_175625_s(packet.pos);
            if (tileentity instanceof ProtoBlockEntity) {
                ProtoBlockEntity protoBlockEntity = (ProtoBlockEntity)tileentity;
                if (!packet.redstoneControl) {
                    protoBlockEntity.setEnabled(packet.enabled);
                }
                protoBlockEntity.setRadius(packet.radius);
                protoBlockEntity.setGamemode(packet.gamemode);
                protoBlockEntity.setMessage(packet.message);
                protoBlockEntity.setBlockItems(packet.blockItems);
                protoBlockEntity.setEnvironementalDamages(packet.environementalDamages);
                protoBlockEntity.setTeleportation(packet.teleportation);
                protoBlockEntity.setFlight(packet.flight);
                protoBlockEntity.setRedstoneControl(packet.redstoneControl);
                protoBlockEntity.setPotion(player, packet.potion);
                BlockState blockstate = player.field_70170_p.func_180495_p(tileentity.func_174877_v());
                tileentity.func_70296_d();
                player.func_71121_q().func_184138_a(tileentity.func_174877_v(), blockstate, blockstate, 3);
                player.func_145747_a((ITextComponent)new StringTextComponent("Settings changed."), player.func_110124_au());
            }
        }
        ctx.get().setPacketHandled(true);
    }
}

