/*
 * Decompiled with CFR 0.152.
 */
package fr.shoqapik.protoblock.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import fr.shoqapik.protoblock.ProtoblockMod;
import fr.shoqapik.protoblock.blocks.ProtoBlockEntity;
import fr.shoqapik.protoblock.packet.CUpdateProtoBlockPacket;
import fr.shoqapik.protoblock.screen.IntegerTextField;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;

public class ProtoBlockScreen
extends Screen {
    private ProtoBlockEntity protoBlockEntity;
    protected Button doneButton;
    protected Button cancelButton;
    private Button enabledButton;
    private Button gamemodeButton;
    private Button blockItemsButton;
    private Button environementalDamagesButton;
    private Button teleportationButton;
    private Button flightButton;
    private Button redstoneControlButton;
    protected TextFieldWidget radiusEdit;
    protected TextFieldWidget messageEdit;
    private TextFieldWidget potionEdit;
    private boolean enabled;
    private int radius;
    private int gamemode;
    private boolean blockItems;
    private boolean environementalDamages;
    private boolean teleportation;
    private boolean flight;
    private boolean redstoneControl;

    public ProtoBlockScreen(ProtoBlockEntity protoBlockEntity) {
        super(NarratorChatListener.field_216868_a);
        this.protoBlockEntity = protoBlockEntity;
    }

    public void func_231023_e_() {
        this.radiusEdit.func_146178_a();
    }

    protected void func_231160_c_() {
        this.enabled = this.protoBlockEntity.isEnabled();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.radiusEdit = new IntegerTextField(this.field_230712_o_, this.field_230708_k_ / 2 - 50, 70, 100, 20, (ITextComponent)new TranslationTextComponent("advMode.command")){

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_230529_a_(NarratorChatListener.field_216868_a);
            }
        };
        this.radiusEdit.func_146203_f(3);
        this.radiusEdit.func_212954_a(this::onRadiusEdit);
        this.enabledButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 4 - 150, 100, 150, 20, (ITextComponent)new StringTextComponent("enabled"), p_214190_1_ -> {
            this.enabled = !this.enabled;
            this.updateEnabled();
        }));
        this.gamemodeButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, 100, 150, 20, (ITextComponent)new StringTextComponent("gamemode"), p_214190_1_ -> this.increaseGamemode()));
        this.messageEdit = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 150, 135, 300, 20, (ITextComponent)new TranslationTextComponent("advMode.command")){

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_230529_a_(NarratorChatListener.field_216868_a);
            }
        };
        this.blockItemsButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 4 - 150, 165, 150, 20, (ITextComponent)new StringTextComponent("blockItemsButton"), p_214190_1_ -> {
            this.blockItems = !this.blockItems;
            this.updateBlockItems();
        }));
        this.environementalDamagesButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, 165, 150, 20, (ITextComponent)new StringTextComponent("environementalDamagesButton"), p_214190_1_ -> {
            this.environementalDamages = !this.environementalDamages;
            this.updateEnvironementalDamages();
        }));
        this.teleportationButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 4 - 150, 195, 150, 20, (ITextComponent)new StringTextComponent("teleportation"), p_214190_1_ -> {
            this.teleportation = !this.teleportation;
            this.updateTeleportation();
        }));
        this.flightButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, 195, 150, 20, (ITextComponent)new StringTextComponent("flight"), p_214190_1_ -> {
            this.flight = !this.flight;
            this.updateFlight();
        }));
        this.redstoneControlButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 4 - 150, 225, 150, 20, (ITextComponent)new StringTextComponent("flight"), p_214190_1_ -> {
            this.redstoneControl = !this.redstoneControl;
            this.updateRedstoneControl(false);
        }));
        this.potionEdit = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + 4, 225, 150, 20, (ITextComponent)new TranslationTextComponent("advMode.command")){

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_230529_a_(NarratorChatListener.field_216868_a);
            }
        };
        this.doneButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 4 - 150, 285, 150, 20, DialogTexts.field_240632_c_, p_214187_1_ -> this.onDone()));
        this.cancelButton = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 4, 285, 150, 20, DialogTexts.field_240633_d_, p_214186_1_ -> this.func_231175_as__()));
        this.messageEdit.func_146203_f(32500);
        this.potionEdit.func_146203_f(200);
        this.potionEdit.func_212954_a(this::onPotionEdit);
        this.field_230705_e_.add(this.radiusEdit);
        this.field_230705_e_.add(this.messageEdit);
        this.field_230705_e_.add(this.potionEdit);
    }

    public void func_231152_a_(Minecraft p_231152_1_, int p_231152_2_, int p_231152_3_) {
        super.func_231152_a_(p_231152_1_, p_231152_2_, p_231152_3_);
        String s = this.messageEdit.func_146179_b();
        this.func_231158_b_(p_231152_1_, p_231152_2_, p_231152_3_);
        this.updateGui();
        this.messageEdit.func_146180_a(s);
    }

    private void onDone() {
        this.populateAndSendPacket();
        this.field_230706_i_.popGuiLayer();
    }

    private void updateEnabled() {
        if (this.enabled) {
            this.enabledButton.func_238482_a_((ITextComponent)new StringTextComponent("Enabled"));
        } else {
            this.enabledButton.func_238482_a_((ITextComponent)new StringTextComponent("Disabled"));
        }
    }

    private void increaseGamemode() {
        ++this.gamemode;
        GameType newGameType = null;
        for (GameType gametype : GameType.values()) {
            if (gametype.func_77148_a() != this.gamemode) continue;
            newGameType = gametype;
        }
        if (newGameType == null) {
            this.gamemode = 0;
            newGameType = GameType.func_77146_a((int)this.gamemode);
        }
        this.updateGamemode(newGameType);
    }

    private void updateBlockItems() {
        if (this.blockItems) {
            this.blockItemsButton.func_238482_a_((ITextComponent)new StringTextComponent("Block Items: On"));
        } else {
            this.blockItemsButton.func_238482_a_((ITextComponent)new StringTextComponent("Block Items: Off"));
        }
    }

    private void updateEnvironementalDamages() {
        if (this.environementalDamages) {
            this.environementalDamagesButton.func_238482_a_((ITextComponent)new StringTextComponent("Environmental Damages: On"));
        } else {
            this.environementalDamagesButton.func_238482_a_((ITextComponent)new StringTextComponent("Environmental Damages: Off"));
        }
    }

    private void updateTeleportation() {
        if (this.teleportation) {
            this.teleportationButton.func_238482_a_((ITextComponent)new StringTextComponent("Teleportation: On"));
        } else {
            this.teleportationButton.func_238482_a_((ITextComponent)new StringTextComponent("Teleportation: Off"));
        }
    }

    private void updateFlight() {
        if (this.flight) {
            this.flightButton.func_238482_a_((ITextComponent)new StringTextComponent("Flight: On"));
        } else {
            this.flightButton.func_238482_a_((ITextComponent)new StringTextComponent("Flight: Off"));
        }
    }

    private void updateRedstoneControl(boolean first) {
        if (this.redstoneControl) {
            this.redstoneControlButton.func_238482_a_((ITextComponent)new StringTextComponent("Redstone Control: On"));
            this.enabledButton.field_230693_o_ = false;
            if (!first) {
                this.enabled = false;
                this.updateEnabled();
            }
        } else {
            this.redstoneControlButton.func_238482_a_((ITextComponent)new StringTextComponent("Redstone Control: Off"));
            this.enabledButton.field_230693_o_ = true;
        }
    }

    private void updateGamemode(GameType newGameType) {
        this.gamemodeButton.func_238482_a_(newGameType.func_196220_c());
    }

    private void onRadiusEdit(String newRadiusStr) {
        block3: {
            try {
                int newRadius = Integer.parseInt(newRadiusStr);
                if (newRadius > 256) {
                    newRadius = 256;
                }
                this.radius = newRadius;
            }
            catch (NumberFormatException e) {
                if (this.radiusEdit.func_146179_b().isEmpty()) break block3;
                this.radiusEdit.func_146180_a("32");
            }
        }
    }

    private void onPotionEdit(String newPotion) {
        if (newPotion.isEmpty()) {
            this.potionEdit.func_146193_g(0xE0E0E0);
        } else if (Potion.func_185168_a((String)this.potionEdit.func_146179_b()) != Potions.field_185229_a) {
            this.potionEdit.func_146193_g(Color.GREEN.getRGB());
        } else {
            this.potionEdit.func_146193_g(0xFF0000);
        }
    }

    public void updateGui() {
        this.enabled = this.protoBlockEntity.isEnabled();
        this.radius = this.protoBlockEntity.getRadius();
        this.gamemode = this.protoBlockEntity.getGamemode();
        this.blockItems = this.protoBlockEntity.isBlockItems();
        this.environementalDamages = this.protoBlockEntity.isEnvironementalDamages();
        this.teleportation = this.protoBlockEntity.isTeleportation();
        this.flight = this.protoBlockEntity.isFlight();
        this.redstoneControl = this.protoBlockEntity.isRedstoneControl();
        this.messageEdit.func_146180_a(this.protoBlockEntity.getMessage());
        this.potionEdit.func_146180_a(this.protoBlockEntity.getPotion());
        this.radiusEdit.func_146180_a(String.valueOf(this.radius));
        this.updateEnabled();
        this.updateGamemode(GameType.func_77146_a((int)this.gamemode));
        this.updateBlockItems();
        this.updateEnvironementalDamages();
        this.updateTeleportation();
        this.updateFlight();
        this.updateRedstoneControl(true);
    }

    protected void populateAndSendPacket() {
        ProtoblockMod.NETWORK.sendToServer((Object)new CUpdateProtoBlockPacket(new BlockPos((Vector3i)this.protoBlockEntity.func_174877_v()), this.enabled, this.radius, this.gamemode, this.messageEdit.func_146179_b(), this.blockItems, this.environementalDamages, this.teleportation, this.flight, this.redstoneControl, this.potionEdit.func_146179_b()));
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_230446_a_(p_230430_1_);
        ProtoBlockScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("Protoblock Settings"), (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        ProtoBlockScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("Radius"), (int)(this.field_230708_k_ / 2 - 50), (int)60, (int)0xA0A0A0);
        ProtoBlockScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("Message"), (int)(this.field_230708_k_ / 2 - 150), (int)125, (int)0xA0A0A0);
        this.radiusEdit.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        this.messageEdit.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        this.potionEdit.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        if (this.potionEdit.func_146179_b().isEmpty()) {
            ProtoBlockScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("Potion effect "), (int)(this.field_230708_k_ / 2 + 8), (int)231, (int)0xA0A0A0);
        }
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }
}

