/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.entity.ICasted;
import mod.vemerion.wizardstaff.entity.MagicVexEntity;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class CreateEntityMagic
extends Magic {
    protected EntityType<?> entity;
    protected SoundEvent sound;
    private JsonObject additionalData;

    public CreateEntityMagic(MagicType<? extends CreateEntityMagic> type) {
        super(type);
    }

    public CreateEntityMagic setAdditionalParams(EntityType<?> entity, SoundEvent sound) {
        return this.setAdditionalParams(entity, sound, null);
    }

    public CreateEntityMagic setAdditionalParams(EntityType<?> entity, SoundEvent sound, JsonObject additionalData) {
        this.entity = entity;
        this.sound = sound;
        this.additionalData = additionalData;
        return this;
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.entity, "entity");
        MagicUtil.write(json, this.sound, "sound");
        json.add("additional_data", (JsonElement)this.additionalData);
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.entity = (EntityType)MagicUtil.read(json, ForgeRegistries.ENTITIES, "entity");
        this.sound = (SoundEvent)MagicUtil.read(json, ForgeRegistries.SOUND_EVENTS, "sound");
        this.additionalData = GsonHelper.m_13841_((JsonObject)json, (String)"additional_data", null);
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        MagicUtil.encode(buffer, this.entity);
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.entity = (EntityType)MagicUtil.decode(buffer);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::buildup;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        if (!level.f_46443_) {
            List<Entity> entities = this.createEntities(level, player, staff);
            for (Entity e : entities) {
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(player.m_142538_()), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)(this.additionalData == null ? null : new JsonData(this.additionalData)), null);
                }
                if (e instanceof MagicVexEntity) {
                    MagicVexEntity vex = (MagicVexEntity)e;
                    vex.setCaster(player);
                    vex.m_33987_(vex.lifetime());
                }
                if (e instanceof EvokerFangs) {
                    EvokerFangs fang = (EvokerFangs)e;
                    fang.m_36938_((LivingEntity)player);
                }
                if (e instanceof ICasted) {
                    ICasted casted = (ICasted)e;
                    casted.setCaster(player);
                }
                level.m_7967_(e);
            }
            if (entities.isEmpty()) {
                this.playSoundServer(level, player, ModSounds.POOF, 1.0f, this.soundPitch(player));
            } else {
                this.playSoundServer(level, player, this.sound, 1.0f, this.soundPitch(player));
                this.cost(player);
            }
        }
        return super.magicFinish(level, player, staff);
    }

    protected abstract List<Entity> createEntities(Level var1, Player var2, ItemStack var3);

    public static class JsonData
    implements SpawnGroupData {
        public JsonObject json;

        public JsonData(JsonObject json) {
            this.json = json;
        }
    }
}

