/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.capability.Experience;
import mod.vemerion.wizardstaff.item.MagicArmorItem;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public abstract class Magic {
    public static final int HOUR = 72000;
    protected float cost;
    protected int duration;
    protected Ingredient ingredient;
    private MagicType<?> type;
    private ResourceLocation name;
    private static final DamageSource MAGIC = new DamageSource("wizardstaff.magic").m_19389_();

    public Magic(MagicType<?> type) {
        this.type = type;
    }

    public Magic setParams(float cost, int duration, Ingredient ingredient) {
        this.cost = cost;
        this.duration = duration;
        this.ingredient = ingredient;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.type.getRegistryName();
    }

    public void setName(ResourceLocation name) {
        this.name = name;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public MagicType<?> getType() {
        return this.type;
    }

    public void read(JsonObject json) {
        this.cost = GsonHelper.m_13915_((JsonObject)json, (String)"cost");
        if (this.cost < 0.0f) {
            throw new JsonSyntaxException("The cost of a magic can not be negative");
        }
        this.duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
        if (this.duration < 0) {
            this.duration = 72000;
        }
        this.ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
        this.readAdditional(json);
    }

    protected void readAdditional(JsonObject json) {
    }

    public JsonObject write() {
        JsonObject json = new JsonObject();
        json.addProperty("cost", (Number)Float.valueOf(this.cost));
        json.addProperty("duration", (Number)this.duration);
        json.addProperty("magic", this.getRegistryName().toString());
        json.add("ingredient", this.ingredient.m_43942_());
        this.writeAdditional(json);
        return json;
    }

    protected void writeAdditional(JsonObject json) {
    }

    public void decode(FriendlyByteBuf buffer) {
        this.cost = buffer.readFloat();
        this.duration = buffer.readInt();
        if (this.duration < 0) {
            this.duration = 72000;
        }
        this.ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        this.decodeAdditional(buffer);
    }

    protected void decodeAdditional(FriendlyByteBuf buffer) {
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.cost);
        buffer.writeInt(this.duration);
        this.ingredient.m_43923_(buffer);
        this.encodeAdditional(buffer);
    }

    protected void encodeAdditional(FriendlyByteBuf buffer) {
    }

    public final ItemStack[] getMatchingStacks() {
        return this.ingredient.m_43908_();
    }

    protected float soundPitch(Player player) {
        return 0.8f + player.m_21187_().nextFloat() * 0.4f;
    }

    protected void playSoundServer(Level level, Player player, SoundEvent sound, float volume, float pitch) {
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.PLAYERS, volume, pitch);
    }

    protected final void cost(Player player, int multiplier) {
        int whole = Experience.add(player, (double)((float)multiplier * this.cost) * this.discount(player));
        double debt = this.debt(player, whole);
        player.m_6756_(-whole);
        if (debt > 0.0) {
            player.m_6469_(DamageSource.f_19319_, (float)debt);
        }
    }

    protected final void cost(Player player) {
        this.cost(player, 1);
    }

    private double discount(Player player) {
        return 1.0 - 0.1 * (double)MagicArmorItem.countMagicArmorPieces(player);
    }

    private double debt(Player player, double amount) {
        int trueLevel = player.f_36078_;
        amount -= (double)(player.f_36080_ * (float)player.m_36323_());
        while (--player.f_36078_ >= 0 && amount > 0.0) {
            amount -= (double)player.m_36323_();
        }
        player.f_36078_ = trueLevel;
        return amount;
    }

    public final int getUseDuration(ItemStack staff) {
        return this.duration;
    }

    public final boolean isMagicItem(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public abstract WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer();

    public abstract WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer();

    public abstract UseAnim getUseAnim(ItemStack var1);

    public void magicStart(Level level, Player player, ItemStack staff) {
    }

    public void magicTick(Level level, Player player, ItemStack staff, int count) {
    }

    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        return staff;
    }

    public InteractionResult magicInteractBlock(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public void magicCancel(Level level, Player player, ItemStack staff, int timeLeft) {
    }

    public boolean magicPreventOtherUse(Level level, Player player, ItemStack staff) {
        return false;
    }

    public Description getDescription() {
        return new Description(this);
    }

    protected Object[] getDescrArgs() {
        return Description.NO_ARGS;
    }

    protected Object[] getNameArgs() {
        return Description.NO_ARGS;
    }

    public static DamageSource magicDamage() {
        return MAGIC;
    }

    public static DamageSource magicDamage(Player player) {
        return new EntityDamageSource("wizardstaff.magicplayer", (Entity)player).m_19389_();
    }

    public static DamageSource magicDamage(Entity source, Player player) {
        return new IndirectEntityDamageSource("wizardstaff.magicindirect", source, (Entity)player).m_19389_();
    }

    public static class Description {
        private static final Object[] NO_ARGS = new Object[0];
        private float cost;
        private int duration;
        private TranslatableComponent name;
        private TranslatableComponent descr;

        private Description(Magic magic) {
            this.cost = magic.cost;
            this.duration = magic.duration;
            ResourceLocation regName = magic.getRegistryName();
            String customName = "gui." + magic.name.m_135827_() + "." + magic.name.m_135815_() + ".name";
            String standardName = "gui." + regName.m_135827_() + "." + regName.m_135815_() + ".name";
            String customDescr = "gui." + magic.name.m_135827_() + "." + magic.name.m_135815_() + ".description";
            String standardDescr = "gui." + regName.m_135827_() + "." + regName.m_135815_() + ".description";
            this.name = new TranslatableComponent(Description.hasTranslation(customName) ? customName : standardName, magic.getNameArgs());
            this.descr = new TranslatableComponent(Description.hasTranslation(customDescr) ? customDescr : standardDescr, magic.getDescrArgs());
        }

        private static boolean hasTranslation(String key) {
            return Language.m_128107_().m_6722_(key);
        }

        public float getCost() {
            return this.cost;
        }

        public int getDuration() {
            return this.duration;
        }

        public TranslatableComponent getName() {
            return this.name;
        }

        public TranslatableComponent getDescription() {
            return this.descr;
        }
    }
}

