/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MagicUtil {
    public static <T extends IForgeRegistryEntry<T>> T read(JsonObject json, IForgeRegistry<T> registry, String member) {
        ResourceLocation key = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)member));
        if (registry.containsKey(key)) {
            return (T)registry.getValue(key);
        }
        throw new JsonParseException("Invalid registry key " + key + " for registry " + registry.getRegistryName().m_135815_());
    }

    public static <T extends IForgeRegistryEntry<T>> T read(JsonObject json, IForgeRegistry<T> registry, String member, T fallback) {
        return json.has(member) ? MagicUtil.read(json, registry, member) : fallback;
    }

    public static <T extends IForgeRegistryEntry<T>> void write(JsonObject json, T obj, String member) {
        String key = obj.getRegistryName().toString();
        json.addProperty(member, key);
    }

    public static <T extends IForgeRegistryEntry<T>> void encode(FriendlyByteBuf buffer, T obj) {
        buffer.writeRegistryId(obj);
    }

    public static <T extends IForgeRegistryEntry<T>> T decode(FriendlyByteBuf buffer) {
        return (T)buffer.readRegistryId();
    }

    public static <T> T read(JsonObject json, Registry<T> registry, String member) {
        ResourceLocation key = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)member));
        Optional value = registry.m_6612_(key);
        if (value.isPresent()) {
            return value.get();
        }
        throw new JsonParseException("Invalid registry key " + key + " for registry " + registry.m_123023_().m_135782_().m_135815_());
    }

    public static <T> T read(JsonObject json, Registry<T> registry, String member, T fallback) {
        return json.has(member) ? MagicUtil.read(json, registry, member) : fallback;
    }

    public static <T> void write(JsonObject json, T obj, Registry<T> registry, String member) {
        json.addProperty(member, registry.m_7981_(obj).toString());
    }

    public static <T> void encode(FriendlyByteBuf buffer, T obj, Registry<T> registry) {
        String key = registry.m_7981_(obj).toString();
        buffer.writeInt(key.length());
        buffer.m_130070_(key);
    }

    public static <T> T decode(FriendlyByteBuf buffer, Registry<T> registry) {
        int keyLen = buffer.readInt();
        return (T)registry.m_7745_(new ResourceLocation(buffer.m_130136_(keyLen)));
    }

    public static BlockPos readBlockPos(JsonObject json, String member) {
        Optional pos = BlockPos.f_121852_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get(member)).result();
        if (!pos.isPresent()) {
            throw new JsonParseException("Missing or invalid BlockPos for member " + member);
        }
        return (BlockPos)pos.get();
    }

    public static void writeBlockPos(JsonObject json, String member, BlockPos pos) {
        BlockPos.f_121852_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pos).result().ifPresent(elem -> json.add(member, elem));
    }

    public static <T, C extends Collection<T>> C readColl(JsonObject json, String member, Function<JsonElement, T> f, C coll) {
        JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)member);
        array.forEach(e -> coll.add(f.apply((JsonElement)e)));
        return coll;
    }

    public static <T> void writeColl(JsonObject json, String member, Collection<T> coll, Function<T, JsonElement> f) {
        JsonArray array = new JsonArray();
        for (T t : coll) {
            array.add(f.apply(t));
        }
        json.add(member, (JsonElement)array);
    }

    public static <T, C extends Collection<T>> C decodeColl(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> f, C coll) {
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            coll.add(f.apply(buffer));
        }
        return coll;
    }

    public static <T> void encodeColl(FriendlyByteBuf buffer, Collection<T> coll, BiConsumer<FriendlyByteBuf, T> f) {
        buffer.writeInt(coll.size());
        for (T t : coll) {
            f.accept(buffer, (FriendlyByteBuf)t);
        }
    }
}

