/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.init.ModMagics;
import mod.vemerion.wizardstaff.network.Network;
import mod.vemerion.wizardstaff.network.UpdateMagicsMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Magics
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String FOLDER_NAME = "wizardstaffmagics";
    private static Magics clientInstance;
    private static Magics serverInstance;
    private Map<ResourceLocation, Magic> magics = new HashMap<ResourceLocation, Magic>();
    private Map<Item, ResourceLocation> cache = new HashMap<Item, ResourceLocation>();

    private Magics() {
        super(GSON, FOLDER_NAME);
    }

    public Magic get(ItemStack stack) {
        Item item = stack.m_41720_();
        if (this.cache.containsKey(item) && this.magics.get(this.cache.get(item)).isMagicItem(stack)) {
            return this.magics.get(this.cache.get(item));
        }
        for (Map.Entry<ResourceLocation, Magic> entry : this.magics.entrySet()) {
            if (!entry.getValue().isMagicItem(stack)) continue;
            Magic magic = entry.getValue();
            this.cache.put(stack.m_41720_(), entry.getKey());
            return magic;
        }
        return ModMagics.NO_MAGIC.create(new ResourceLocation("wizardstaff", "no_magic"));
    }

    public static Magics getInstance(boolean isRemote) {
        return isRemote ? clientInstance : serverInstance;
    }

    public static Magics getInstance(Level level) {
        return Magics.getInstance(level.f_46443_);
    }

    public static void init() {
        clientInstance = new Magics();
        serverInstance = new Magics();
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        HashMap<ResourceLocation, Magic> newMagics = new HashMap<ResourceLocation, Magic>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonObject json = GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element");
            ResourceLocation magicKey = this.toResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"magic"));
            if (!ModMagics.getRegistry().containsKey(magicKey)) {
                throw new JsonSyntaxException("The magic " + magicKey + " does not exist");
            }
            MagicType type = (MagicType)ModMagics.getRegistry().getValue(magicKey);
            if (type == ModMagics.NO_MAGIC) continue;
            Object magic = type.create(key);
            ((Magic)magic).read(json);
            newMagics.put(key, (Magic)magic);
        }
        this.addMagics(newMagics);
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            this.sendMagicMessage(newMagics);
        }
    }

    private ResourceLocation toResourceLocation(String string) {
        if (string.contains(":")) {
            return new ResourceLocation(string);
        }
        return new ResourceLocation("wizardstaff", string);
    }

    private void sendMagicMessage(Map<ResourceLocation, Magic> newMagics) {
        Network.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UpdateMagicsMessage(newMagics));
    }

    public void sendAllMagicMessage(ServerPlayer reciever) {
        Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> reciever), (Object)new UpdateMagicsMessage(this.magics));
    }

    public void addMagics(Map<ResourceLocation, Magic> newMagics) {
        this.cache = new HashMap<Item, ResourceLocation>();
        this.magics.putAll(newMagics);
    }

    public Set<ItemStack> getMagicItems() {
        HashSet<ItemStack> items = new HashSet<ItemStack>();
        for (Magic m : this.magics.values()) {
            for (ItemStack stack : m.getMatchingStacks()) {
                items.add(stack);
            }
        }
        return items;
    }
}

