/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.RegistryMatch;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class MassHandleBlockMagic
extends Magic {
    private RegistryMatch<Block> match;
    private int harvestLimit;

    public MassHandleBlockMagic(MagicType<? extends MassHandleBlockMagic> type) {
        super(type);
    }

    public MassHandleBlockMagic setAdditionalParams(RegistryMatch<Block> match, int harvestLimit) {
        this.match = match;
        this.harvestLimit = harvestLimit;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.match = RegistryMatch.read(ForgeRegistries.BLOCKS, GsonHelper.m_13930_((JsonObject)json, (String)"block_match"));
        this.harvestLimit = GsonHelper.m_13927_((JsonObject)json, (String)"block_limit");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.add("block_match", (JsonElement)this.match.write());
        json.addProperty("block_limit", (Number)this.harvestLimit);
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        this.match.encode(buffer);
        buffer.writeInt(this.harvestLimit);
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.match = RegistryMatch.decode(ForgeRegistries.BLOCKS, buffer);
        this.harvestLimit = buffer.readInt();
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::drill;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.match.getName()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{new TextComponent(String.valueOf(this.harvestLimit)), this.match.getName()};
    }

    @Override
    public boolean magicPreventOtherUse(Level level, Player player, ItemStack staff) {
        BlockHitResult result = Helper.blockRay(level, player, 4.0f);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return this.match.test(level.m_8055_(result.m_82425_()).m_60734_());
        }
        return false;
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        BlockHitResult result = Helper.blockRay(level, player, 4.0f);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockState state = level.m_8055_(result.m_82425_());
            if (this.match.test(state.m_60734_())) {
                player.m_5496_(state.m_60827_().m_56775_(), 1.0f, this.soundPitch(player));
                if (!level.f_46443_) {
                    this.cost(player, this.handleBlocks(result.m_82425_(), state.m_60734_(), level, player, staff));
                }
            } else {
                player.m_5496_(ModSounds.POOF, 1.0f, this.soundPitch(player));
            }
        }
        return super.magicFinish(level, player, staff);
    }

    private int handleBlocks(BlockPos start, Block type, Level level, Player player, ItemStack staff) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        HashSet found = new HashSet();
        positions.add(start);
        while (!positions.isEmpty()) {
            BlockPos pos = (BlockPos)positions.remove(0);
            BlockPos.m_121990_((BlockPos)pos.m_141952_(this.searchOffset().m_142393_(-1)), (BlockPos)pos.m_141952_(this.searchOffset())).forEach(p -> {
                if (found.size() < this.harvestLimit && !found.contains(p) && type == level.m_8055_(p).m_60734_()) {
                    BlockPos immutable = p.m_7949_();
                    positions.add(immutable);
                    found.add(immutable);
                }
            });
            this.handleBlock(level, pos, player, staff);
        }
        return found.size();
    }

    protected abstract void handleBlock(Level var1, BlockPos var2, Player var3, ItemStack var4);

    protected abstract Vec3i searchOffset();
}

