/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public abstract class RayMagic
extends Magic {
    public RayMagic(MagicType<? extends RayMagic> type) {
        super(type);
    }

    protected float getRange() {
        return 7.0f;
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        if (count % 10 == 0) {
            player.m_5496_(ModSounds.RAY, 0.6f, 0.95f + player.m_21187_().nextFloat() * 0.05f);
        }
        if (level.f_46443_) {
            Vec3 direction = Vec3.m_82503_((Vec2)player.m_20155_());
            Entity target = Helper.findTargetLine(player.m_20182_().m_82520_(0.0, 1.5, 0.0), direction, this.getRange(), level, (LivingEntity)player);
            if (target != null) {
                Vec3 pos = player.m_20182_().m_82520_(0.0, 1.5, 0.0).m_82549_(direction);
                for (int i = 0; i < 25; ++i) {
                    level.m_7106_(this.generateParticle(level, player, staff, count), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.1, 0.1, 0.1);
                    pos = pos.m_82549_(direction.m_82490_(0.3));
                    if (target.m_142469_().m_82381_(new AABB(pos, pos).m_82400_(0.25))) break;
                }
            }
        }
    }

    protected abstract ParticleOptions generateParticle(Level var1, Player var2, ItemStack var3, int var4);

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        Entity target;
        if (!level.f_46443_ && (target = Helper.findTargetLine(player.m_20182_().m_82520_(0.0, 1.5, 0.0), Vec3.m_82503_((Vec2)player.m_20155_()), this.getRange(), level, (LivingEntity)player)) != null) {
            this.hitEntity(level, player, target);
        }
        return super.magicFinish(level, player, staff);
    }

    protected abstract void hitEntity(Level var1, Player var2, Entity var3);

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::forward;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.BLOCK;
    }
}

