/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.Predicate;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryMatch<T extends IForgeRegistryEntry<T>>
implements Predicate<T> {
    private IForgeRegistry<T> registry;
    private T entry;
    private TagKey<T> tag;

    public RegistryMatch(IForgeRegistry<T> registry, T entry) {
        this.registry = registry;
        this.entry = entry;
    }

    public RegistryMatch(IForgeRegistry<T> registry, TagKey<T> tag) {
        this.registry = registry;
        this.tag = tag;
    }

    @Override
    public boolean test(T b) {
        if (this.entry != null) {
            return this.entry == b;
        }
        return this.registry.tags().getTag(this.tag).contains(b);
    }

    public Component getName() {
        if (this.entry != null) {
            return this.getEntryName(this.entry);
        }
        return new TextComponent(this.tag.f_203868_().m_135815_());
    }

    private Component getEntryName(T entry) {
        if (entry instanceof Block) {
            Block block = (Block)entry;
            return block.m_49954_();
        }
        if (entry instanceof EntityType) {
            EntityType entityType = (EntityType)entry;
            return entityType.m_20676_();
        }
        return new TextComponent(entry.getRegistryName().m_135815_());
    }

    public static <T extends IForgeRegistryEntry<T>> RegistryMatch<T> read(IForgeRegistry<T> registry, JsonObject json) {
        String field = registry.getRegistryName().m_135815_();
        if (GsonHelper.m_13900_((JsonObject)json, (String)field)) {
            return new RegistryMatch<T>(registry, MagicUtil.read(json, registry, field));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"tag")) {
            return new RegistryMatch<T>(registry, registry.tags().createTagKey(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"))));
        }
        throw new JsonSyntaxException("RegistryMatch must have either '" + field + "' or 'tag' member");
    }

    public JsonObject write() {
        String field = this.registry.getRegistryName().m_135815_();
        JsonObject json = new JsonObject();
        if (this.entry != null) {
            MagicUtil.write(json, this.entry, field);
        } else {
            json.addProperty("tag", this.tag.f_203868_().toString());
        }
        return json;
    }

    public static <T extends IForgeRegistryEntry<T>> RegistryMatch<T> decode(IForgeRegistry<T> registry, FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new RegistryMatch<T>(registry, MagicUtil.decode(buffer));
        }
        return new RegistryMatch<T>(registry, registry.tags().createTagKey(buffer.m_130281_()));
    }

    public void encode(FriendlyByteBuf buffer) {
        if (this.entry != null) {
            buffer.writeBoolean(true);
            MagicUtil.encode(buffer, this.entry);
        } else {
            buffer.writeBoolean(false);
            buffer.m_130085_(this.tag.f_203868_());
        }
    }
}

