/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public abstract class RepairItemsMagic
extends Magic {
    private int repairRate;

    public RepairItemsMagic(MagicType<? extends RepairItemsMagic> type) {
        super(type);
    }

    public RepairItemsMagic setAdditionalParams(int repairRate) {
        this.repairRate = repairRate;
        return this;
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("repair_rate", (Number)this.repairRate);
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.repairRate = GsonHelper.m_13927_((JsonObject)json, (String)"repair_rate");
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::spinMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        if (!level.f_46443_) {
            ArrayList<ItemStack> broken = new ArrayList<ItemStack>();
            for (ItemStack armor : this.getItems(level, player, staff, count)) {
                if (!armor.m_41768_()) continue;
                broken.add(armor);
            }
            if (!broken.isEmpty()) {
                ItemStack armor = (ItemStack)broken.get(player.m_21187_().nextInt(broken.size()));
                armor.m_41721_(armor.m_41773_() - this.repairRate);
                this.cost(player);
            }
        }
        if (count % 20 == 0) {
            player.m_5496_(ModSounds.ANVIL, 1.0f, this.soundPitch(player));
        }
    }

    protected abstract Iterable<ItemStack> getItems(Level var1, Player var2, ItemStack var3, int var4);
}

