/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.bugfix;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import mod.vemerion.wizardstaff.Magic.CreateEntityMagic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShapedCreateEntityMagic
extends CreateEntityMagic {
    List<String> shape = new ArrayList<String>();
    private List<Pos> spawnPositions = new ArrayList<Pos>();

    public ShapedCreateEntityMagic(MagicType<? extends ShapedCreateEntityMagic> type) {
        super((MagicType<? extends CreateEntityMagic>)type);
    }

    public ShapedCreateEntityMagic setAdditionalParams(List<String> shape) {
        this.shape = shape;
        this.spawnPositions = this.calculateSpawnPositions(shape);
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.shape = MagicUtil.readColl(json, "shape", e -> GsonHelper.m_13805_((JsonElement)e, (String)"row"), new ArrayList());
        this.spawnPositions = this.calculateSpawnPositions(this.shape);
    }

    @Override
    protected Object[] getDescrArgs() {
        return this.getNameArgs();
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.entity.m_20676_()};
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        MagicUtil.writeColl(json, "shape", this.shape, s -> new JsonPrimitive(s));
    }

    private List<Pos> calculateSpawnPositions(List<String> shape) {
        char c;
        int col;
        int row;
        ArrayList<Pos> positions = new ArrayList<Pos>();
        Pos playerPos = null;
        for (row = 0; row < shape.size(); ++row) {
            for (col = 0; col < shape.get(row).length(); ++col) {
                c = shape.get(row).charAt(col);
                if (c != 'p' && c != 'P') continue;
                if (playerPos != null) {
                    throw new IllegalArgumentException("Shape is only allowed to have one player position (p)");
                }
                playerPos = new Pos(row, col);
            }
        }
        if (playerPos == null) {
            throw new IllegalArgumentException("Shape must have a player position (p)");
        }
        for (row = 0; row < shape.size(); ++row) {
            for (col = 0; col < shape.get(row).length(); ++col) {
                c = shape.get(row).charAt(col);
                if (c != 'x' && c != 'X') continue;
                positions.add(new Pos(playerPos.row - row, playerPos.col - col));
            }
        }
        if (positions.isEmpty()) {
            throw new IllegalArgumentException("Shape must have at least on spawn position (x)");
        }
        return positions;
    }

    @Override
    protected List<Entity> createEntities(Level level, Player player, ItemStack staff) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Vec3 forward = Vec3.m_82498_((float)0.0f, (float)player.m_146908_());
        Vec3 right = forward.m_82524_(1.5707964f);
        for (Pos p : this.spawnPositions) {
            Entity e = this.entity.m_20615_(level);
            Vec3 pos = this.findValidPosition(player.m_20182_().m_82549_(forward.m_82490_((double)p.row).m_82549_(right.m_82490_((double)p.col))), level);
            if (pos == null) continue;
            e.m_19890_(pos.f_82479_, pos.f_82480_, pos.f_82481_, player.m_21187_().nextFloat() * 360.0f, 0.0f);
            entities.add(e);
        }
        return entities;
    }

    private Vec3 findValidPosition(Vec3 position, Level level) {
        int[] heights;
        for (int height : heights = new int[]{0, -1, 1}) {
            BlockPos pos = new BlockPos(position).m_6630_(height);
            if (level.m_8055_(pos).m_60815_() || !level.m_8055_(pos.m_7495_()).m_60815_()) continue;
            return new Vec3(position.f_82479_, (double)pos.m_123342_(), position.f_82481_);
        }
        return null;
    }

    private static class Pos {
        int row;
        int col;

        private Pos(int row, int col) {
            this.row = row;
            this.col = col;
        }
    }
}

