/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.cavesandcliffs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Random;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.RayMagic;
import mod.vemerion.wizardstaff.Magic.RegistryMatch;
import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.capability.Wizard;
import mod.vemerion.wizardstaff.particle.MagicDustParticleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class MountMagic
extends RayMagic {
    private static Method jumpFromGround = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_6135_", (Class[])new Class[0]);
    private RegistryMatch<EntityType<?>> match;

    public MountMagic(MagicType<? extends MountMagic> type) {
        super((MagicType<? extends RayMagic>)type);
    }

    public MountMagic setAdditionalParams(RegistryMatch<EntityType<?>> match) {
        this.match = match;
        return this;
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.match.getName()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return this.getNameArgs();
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.match = RegistryMatch.read(ForgeRegistries.ENTITIES, GsonHelper.m_13930_((JsonObject)json, (String)"match"));
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.add("match", (JsonElement)this.match.write());
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.match = RegistryMatch.decode(ForgeRegistries.ENTITIES, buffer);
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        this.match.encode(buffer);
    }

    @Override
    protected ParticleOptions generateParticle(Level level, Player player, ItemStack staff, int count) {
        Random rand = player.m_21187_();
        return new MagicDustParticleData(0.8f + rand.nextFloat() * 0.2f, 0.8f + rand.nextFloat() * 0.2f, 0.8f + rand.nextFloat() * 0.2f, 1.0f);
    }

    private boolean isValidEntity(Entity target) {
        return target != null && this.match.test(target.m_6095_());
    }

    @Override
    protected void hitEntity(Level level, Player player, Entity target) {
        if (this.isValidEntity(target)) {
            player.m_20329_(target);
        }
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        if (this.isValidEntity(player.m_20202_())) {
            this.cost(player);
            this.controlMount(player);
        } else {
            super.magicTick(level, player, staff, count);
        }
    }

    private void controlMount(Player player) {
        Entity entity = player.m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Vec3 movement = Vec3.m_82498_((float)0.0f, (float)player.m_146908_()).m_82490_(0.4).m_82520_(0.0, living.m_20184_().f_82480_, 0.0);
            living.m_20256_(movement);
            living.m_146922_(player.m_146908_());
            if (player.m_146909_() < -30.0f) {
                Wizard.getWizardOptional(player).ifPresent(w -> {
                    if (w.mountJump()) {
                        try {
                            jumpFromGround.invoke((Object)living, new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            Main.LOGGER.warn("Could not jump with goat, error: " + e);
                        }
                    }
                });
            }
        }
    }
}

