/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.cavesandcliffs;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class PlaceLightRandomMagic
extends Magic {
    private int radius;
    private int lightLevel;
    private BlockItem item;

    public PlaceLightRandomMagic(MagicType<? extends PlaceLightRandomMagic> type) {
        super(type);
    }

    public PlaceLightRandomMagic setAdditionalParams(int radius, int lightLevel, BlockItem item) {
        this.radius = radius;
        this.lightLevel = lightLevel;
        this.item = item;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        BlockItem blockItem;
        this.radius = GsonHelper.m_13927_((JsonObject)json, (String)"radius");
        this.lightLevel = GsonHelper.m_13927_((JsonObject)json, (String)"light_level");
        Object t = MagicUtil.read(json, ForgeRegistries.ITEMS, "item");
        if (!(t instanceof BlockItem)) {
            throw new JsonParseException("Item for PlaceLightRandomMagic must be a BlockItem");
        }
        this.item = blockItem = (BlockItem)t;
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("radius", (Number)this.radius);
        json.addProperty("light_level", (Number)this.lightLevel);
        MagicUtil.write(json, this.item, "item");
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.radius = buffer.readInt();
        this.lightLevel = buffer.readInt();
        this.item = (BlockItem)MagicUtil.decode(buffer);
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.radius);
        buffer.writeInt(this.lightLevel);
        MagicUtil.encode(buffer, this.item);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::spinMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.item.m_7626_(this.item.m_7968_()), this.radius, this.lightLevel};
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        if (!level.f_46443_) {
            AABB box = new AABB(player.m_142538_()).m_82400_((double)this.radius);
            for (int i = 0; i < 100; ++i) {
                DirectionalPlaceContext context;
                BlockPos p = Helper.randPosInBox(box, player.m_21187_());
                if (level.m_45517_(LightLayer.BLOCK, p) > this.lightLevel || this.item.m_40576_((BlockPlaceContext)(context = new DirectionalPlaceContext(level, p, Direction.NORTH, this.item.m_7968_(), Direction.DOWN))) == InteractionResult.FAIL) continue;
                this.cost(player);
                break;
            }
        }
    }
}

