/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.cavesandcliffs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.RegistryMatch;
import mod.vemerion.wizardstaff.capability.Wizard;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class XRayMagic
extends Magic {
    private int range;
    private RegistryMatch<Block> match;

    public XRayMagic(MagicType<? extends XRayMagic> type) {
        super(type);
    }

    public XRayMagic setAdditionalParams(int range, RegistryMatch<Block> match) {
        this.range = range;
        this.match = match;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.range = GsonHelper.m_13927_((JsonObject)json, (String)"range");
        this.match = RegistryMatch.read(ForgeRegistries.BLOCKS, GsonHelper.m_13930_((JsonObject)json, (String)"match"));
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("range", (Number)this.range);
        json.add("match", (JsonElement)this.match.write());
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.range = buffer.readInt();
        this.match = RegistryMatch.decode(ForgeRegistries.BLOCKS, buffer);
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.range);
        this.match.encode(buffer);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::circling;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::swinging;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.match.getName(), new TextComponent(String.valueOf(this.range))};
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.match.getName()};
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        if (!level.f_46443_) {
            this.cost(player);
        } else {
            this.findOres(Helper.randPosInBox(new AABB(player.m_142538_()).m_82400_((double)this.range), player.m_21187_()), player, level);
        }
    }

    private void findOres(BlockPos start, Player player, Level level) {
        Wizard.getWizardOptional(player).ifPresent(w -> BlockPos.m_121921_((AABB)new AABB(start).m_82400_(8.0)).forEach(p -> {
            if (this.match.test(level.m_8055_(p).m_60734_())) {
                w.getXRayed().add(p.m_7949_());
            }
        }));
    }
}

