/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.netherupdate;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.capability.Wizard;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class LodestoneMagic
extends Magic {
    private Block waypoint;

    public LodestoneMagic(MagicType<? extends LodestoneMagic> type) {
        super(type);
    }

    public LodestoneMagic setAdditionalParams(Block waypoint) {
        this.waypoint = waypoint;
        return this;
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.waypoint = (Block)MagicUtil.decode(buffer);
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        MagicUtil.encode(buffer, this.waypoint);
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.waypoint = (Block)MagicUtil.read(json, ForgeRegistries.BLOCKS, "waypoint");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.waypoint, "waypoint");
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.waypoint.m_49954_()};
    }

    @Override
    public InteractionResult magicInteractBlock(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (level.m_8055_(context.m_8083_()).m_60734_() == this.waypoint) {
            player.m_5496_(ModSounds.GONG, 1.0f, this.soundPitch(player));
            if (!level.f_46443_) {
                Wizard.getWizard(player).trackLodestone(level, context.m_8083_(), this.waypoint);
            }
            return InteractionResult.SUCCESS;
        }
        return super.magicInteractBlock(context);
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        if (!level.f_46443_ && Wizard.getWizard(player).lodestoneTeleport((ServerPlayer)player, this.waypoint)) {
            this.playSoundServer(level, player, ModSounds.GONG, 1.0f, this.soundPitch(player));
            this.cost(player);
        }
        return super.magicFinish(level, player, staff);
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        if (count % 10 == 0) {
            player.m_5496_(ModSounds.TELEPORT, 1.0f, this.soundPitch(player));
        }
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::buildup;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }
}

