/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.netherupdate;

import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class NetherrackMagic
extends Magic {
    public NetherrackMagic(MagicType<? extends NetherrackMagic> type) {
        super(type);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::swinging;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::swinging;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        if (!level.f_46443_ && player.f_19797_ % 10 == 0 && this.rackify(level, player)) {
            this.cost(player);
            this.playSoundServer(level, player, SoundEvents.f_12447_, 1.0f, this.soundPitch(player));
        }
    }

    private boolean rackify(Level level, Player player) {
        boolean hasRackified = false;
        if (player.m_20096_()) {
            BlockState netherrack = Blocks.f_50134_.m_49966_();
            float range = 2.0f;
            BlockPos start = new BlockPos(player.m_20182_()).m_142022_((double)(-range), -1.0, (double)(-range));
            BlockPos stop = new BlockPos(player.m_20182_()).m_142022_((double)range, -1.0, (double)range);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)start, (BlockPos)stop)) {
                if (!this.canBeRackified(level, pos) || !level.m_45752_(netherrack, pos, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)pos), (Direction)Direction.UP)) continue;
                level.m_46597_(pos, netherrack);
                hasRackified = true;
            }
        }
        return hasRackified;
    }

    private boolean canBeRackified(Level level, BlockPos pos) {
        FluidState fluidState = level.m_6425_(pos);
        return level.m_46859_(pos.m_7494_()) && fluidState.m_205070_(FluidTags.f_13132_) && fluidState.m_76170_();
    }
}

