/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.netherupdate;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ProjectileMagic
extends Magic {
    private EntityType<?> projectileType;
    private SoundEvent sound;
    private float speed;

    public ProjectileMagic(MagicType<? extends ProjectileMagic> type) {
        super(type);
    }

    public ProjectileMagic setAdditionalParams(EntityType<?> projectileType, SoundEvent sound, float speed) {
        this.projectileType = projectileType;
        this.sound = sound;
        this.speed = speed;
        return this;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::forwardBuildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.projectileType = (EntityType)MagicUtil.read(json, ForgeRegistries.ENTITIES, "projectile");
        this.sound = (SoundEvent)MagicUtil.read(json, ForgeRegistries.SOUND_EVENTS, "sound");
        this.speed = GsonHelper.m_13915_((JsonObject)json, (String)"speed");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.projectileType, "projectile");
        MagicUtil.write(json, this.sound, "sound");
        json.addProperty("speed", (Number)Float.valueOf(this.speed));
    }

    @Override
    public void encodeAdditional(FriendlyByteBuf buffer) {
        MagicUtil.encode(buffer, this.projectileType);
        MagicUtil.encode(buffer, this.sound);
        buffer.writeFloat(this.speed);
    }

    @Override
    public void decodeAdditional(FriendlyByteBuf buffer) {
        this.projectileType = (EntityType)MagicUtil.decode(buffer);
        this.sound = (SoundEvent)MagicUtil.decode(buffer);
        this.speed = buffer.readFloat();
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.projectileType.m_20676_()};
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.projectileType.m_20676_()};
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        player.m_5496_(this.sound, 1.0f, this.soundPitch(player));
        if (!level.f_46443_) {
            Vec3 direction = Vec3.m_82503_((Vec2)player.m_20155_());
            Vec3 position = player.m_20182_().m_82520_(direction.m_7096_() * 1.0, 1.2, direction.m_7094_() * 1.0);
            this.cost(player);
            Entity entity = this.projectileType.m_20615_(level);
            entity.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
            if (entity instanceof Projectile) {
                Projectile projectile = (Projectile)entity;
                projectile.m_5602_((Entity)player);
                projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.speed, 0.0f);
            }
            level.m_7967_(entity);
        }
        return super.magicFinish(level, player, staff);
    }
}

