/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.original;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.Magic.RayMagic;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.particle.MagicDustParticleData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EggMagic
extends RayMagic {
    private Set<ResourceLocation> blacklist;

    public EggMagic(MagicType<? extends EggMagic> type) {
        super((MagicType<? extends RayMagic>)type);
    }

    public EggMagic setAdditionalParams(Set<ResourceLocation> blacklist) {
        this.blacklist = blacklist;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.blacklist = MagicUtil.readColl(json, "blacklist", e -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)e, (String)"entity name")), new HashSet());
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.writeColl(json, "blacklist", this.blacklist, r -> new JsonPrimitive(r.toString()));
    }

    @Override
    public void hitEntity(Level level, Player player, Entity target) {
        if (this.blacklist.contains(target.m_6095_().getRegistryName())) {
            target.m_5496_(ModSounds.POOF, 1.0f, this.soundPitch(player));
            return;
        }
        SpawnEggItem egg = null;
        for (SpawnEggItem e : SpawnEggItem.m_43233_()) {
            if (e.m_43228_(null) != target.m_6095_()) continue;
            egg = e;
            break;
        }
        if (egg != null) {
            target.m_5496_(ModSounds.PLOP, 1.0f, this.soundPitch(player));
            ItemEntity eggEntity = new ItemEntity(level, target.m_20185_(), target.m_20186_(), target.m_20189_(), new ItemStack((ItemLike)egg));
            level.m_7967_((Entity)eggEntity);
            target.m_146870_();
            this.cost(player);
        } else {
            target.m_5496_(ModSounds.POOF, 1.0f, this.soundPitch(player));
        }
    }

    @Override
    protected ParticleOptions generateParticle(Level level, Player player, ItemStack staff, int count) {
        Random rand = player.m_21187_();
        return new MagicDustParticleData(0.8f + rand.nextFloat() * 0.2f, rand.nextFloat() * 0.2f, 0.8f + rand.nextFloat() * 0.2f, 1.0f);
    }
}

