/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.original;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.network.JukeboxMagicMessage;
import mod.vemerion.wizardstaff.network.Network;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class JukeboxMagic
extends Magic {
    private Set<ResourceLocation> blacklist;
    private float range;
    private SoundEvent music;

    public JukeboxMagic(MagicType<? extends JukeboxMagic> type) {
        super(type);
    }

    public JukeboxMagic setAdditionalParams(Set<ResourceLocation> blacklist, float range, SoundEvent music) {
        this.blacklist = blacklist;
        this.range = range;
        this.music = music;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.blacklist = MagicUtil.readColl(json, "blacklist", e -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)e, (String)"entity name")), new HashSet());
        this.range = GsonHelper.m_13915_((JsonObject)json, (String)"range");
        this.music = (SoundEvent)MagicUtil.read(json, ForgeRegistries.SOUND_EVENTS, "music");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.writeColl(json, "blacklist", this.blacklist, rl -> new JsonPrimitive(rl.toString()));
        json.addProperty("range", (Number)Float.valueOf(this.range));
        MagicUtil.write(json, this.music, "music");
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.blacklist = MagicUtil.decodeColl(buffer, b -> b.m_130281_(), new HashSet());
        this.range = buffer.readFloat();
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        MagicUtil.encodeColl(buffer, this.blacklist, (b, rl) -> b.m_130085_(rl));
        buffer.writeFloat(this.range);
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public void magicStart(Level level, Player player, ItemStack staff) {
        if (!level.f_46443_) {
            Network.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new JukeboxMagicMessage(player.m_142081_(), this.music));
        }
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{new TextComponent(String.valueOf(this.range))};
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        List entities = level.m_6443_(LivingEntity.class, player.m_142469_().m_82400_((double)this.range), e -> e != player && !this.blacklist.contains(e.m_6095_().getRegistryName()));
        for (LivingEntity e2 : entities) {
            if (!level.f_46443_) {
                if (count % 5 != 0) continue;
                e2.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 7, 100, false, false, false));
                continue;
            }
            if (e2.f_19797_ % 5 != 0) continue;
            e2.f_20924_ = 1.0f + player.m_21187_().nextFloat() - 0.5f;
            e2.m_6674_(InteractionHand.MAIN_HAND);
            e2.m_6674_(InteractionHand.OFF_HAND);
        }
        if (!level.f_46443_ && !entities.isEmpty()) {
            this.cost(player);
        }
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::swinging;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::swinging;
    }
}

