/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.original;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WritableBookMagic
extends Magic {
    private List<String> wisdoms;

    public WritableBookMagic(MagicType<? extends WritableBookMagic> type) {
        super(type);
    }

    public WritableBookMagic setAdditionalParams(List<String> wisdoms) {
        this.wisdoms = wisdoms;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.wisdoms = MagicUtil.readColl(json, "wisdoms", e -> GsonHelper.m_13805_((JsonElement)e, (String)"wisdom"), new ArrayList());
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.writeColl(json, "wisdoms", this.wisdoms, JsonPrimitive::new);
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        player.m_5496_(ModSounds.SCRIBBLE, 1.0f, this.soundPitch(player));
        if (!level.f_46443_) {
            String wisdom = this.wisdoms.get(player.m_21187_().nextInt(this.wisdoms.size()));
            WizardStaffItemHandler.getOptional(staff).ifPresent(h -> {
                this.cost(player);
                ItemStack book = h.extractCurrent();
                CompoundTag tag = book.m_41784_();
                ListTag pages = new ListTag();
                pages.add((Object)StringTag.m_129297_((String)wisdom));
                tag.m_128365_("pages", (Tag)pages);
                book = new ItemStack((ItemLike)Items.f_42614_);
                book.m_41751_(tag);
                h.insertCurrent(book);
            });
        }
        return super.magicFinish(level, player, staff);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildupMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }
}

