/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.restructuring;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Optional;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.Main;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class BuilderMagic
extends Magic {
    private ResourceLocation name;
    private Direction front;
    private BlockPos center;
    private BlockPos playerOffset;

    public BuilderMagic(MagicType<? extends BuilderMagic> type) {
        super(type);
    }

    public BuilderMagic setAdditionalParams(ResourceLocation name, Direction front, BlockPos center, BlockPos playerOffset) {
        this.name = name;
        this.front = front;
        this.center = center;
        this.playerOffset = playerOffset;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.name = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"template"));
        String direction = GsonHelper.m_13906_((JsonObject)json, (String)"front");
        this.front = Direction.m_122402_((String)direction);
        if (this.front == null) {
            throw new JsonParseException("Invalid direction " + direction + " for front attribute");
        }
        if (!Direction.Plane.HORIZONTAL.test(this.front)) {
            throw new JsonParseException("Direction must be horizontal for front attribute");
        }
        this.center = MagicUtil.readBlockPos(json, "center");
        this.playerOffset = MagicUtil.readBlockPos(json, "player_offset");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("template", this.name.toString());
        json.addProperty("front", this.front.m_122433_());
        MagicUtil.writeBlockPos(json, "center", this.center);
        MagicUtil.writeBlockPos(json, "player_offset", this.playerOffset);
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        int len = buffer.readInt();
        this.name = new ResourceLocation(buffer.m_130136_(len));
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.name.toString().length());
        buffer.m_130070_(this.name.toString());
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{new TextComponent(this.name.m_135815_())};
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{new TextComponent(this.name.m_135815_())};
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::buildup;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        if (!level.f_46443_ && this.generateStructure((ServerLevel)level, player)) {
            this.cost(player);
            this.playSoundServer(level, player, ModSounds.BUILDING, 1.0f, this.soundPitch(player));
        }
        return super.magicFinish(level, player, staff);
    }

    private boolean generateStructure(ServerLevel level, Player player) {
        Optional templateOpt = level.m_8875_().m_163774_(this.name);
        if (templateOpt.isEmpty()) {
            Main.LOGGER.error("Invalid template name " + this.name);
            return false;
        }
        Direction direction = this.getDirection(player);
        BlockPos offset = BlockPos.f_121853_.m_5484_(direction, this.playerOffset.m_123343_()).m_5484_(direction.m_122427_(), this.playerOffset.m_123341_()).m_5484_(Direction.UP, this.playerOffset.m_123342_());
        BlockPos pos = player.m_142538_().m_141950_((Vec3i)new BlockPos(this.center.m_123341_(), 0, this.center.m_123342_())).m_141952_((Vec3i)offset);
        Rotation rotation = this.calculateRotation(player);
        StructurePlaceSettings settings = new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74385_(this.center).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_).m_74383_((StructureProcessor)new AirStructureProcessor());
        return ((StructureTemplate)templateOpt.get()).m_74536_((ServerLevelAccessor)level, pos, pos, settings, player.m_21187_(), 2);
    }

    private Rotation calculateRotation(Player player) {
        Direction direction = this.getDirection(player).m_122424_();
        if (this.front == direction) {
            return Rotation.NONE;
        }
        if (this.front == direction.m_122427_()) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        if (this.front == direction.m_122428_()) {
            return Rotation.CLOCKWISE_90;
        }
        return Rotation.CLOCKWISE_180;
    }

    private Direction getDirection(Player player) {
        Direction[] directions;
        for (Direction d : directions = Direction.m_122382_((Entity)player)) {
            if (!Direction.Plane.HORIZONTAL.test(d)) continue;
            return d;
        }
        return Direction.NORTH;
    }

    private static class AirStructureProcessor
    extends StructureProcessor {
        private AirStructureProcessor() {
        }

        protected StructureProcessorType<?> m_6953_() {
            return null;
        }

        public StructureTemplate.StructureBlockInfo process(LevelReader world, BlockPos center1, BlockPos center2, StructureTemplate.StructureBlockInfo infoRelative, StructureTemplate.StructureBlockInfo infoAbsolute, StructurePlaceSettings settings, StructureTemplate template) {
            return !world.m_46859_(infoAbsolute.f_74675_) ? null : super.process(world, center1, center2, infoRelative, infoAbsolute, settings, template);
        }
    }
}

