/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.restructuring;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionMagic
extends Magic {
    private int amplifier;
    private int potionTime;
    private float radius;
    private MobEffect potion;
    private boolean affectCaster;
    private SoundEvent sound;

    public PotionMagic(MagicType<? extends PotionMagic> type) {
        super(type);
    }

    public PotionMagic setAdditionalParams(int amplifier, int potionTime, float radius, MobEffect potion, boolean affectCaster, SoundEvent sound) {
        this.amplifier = amplifier;
        this.potionTime = potionTime;
        this.radius = radius;
        this.potion = potion;
        this.affectCaster = affectCaster;
        this.sound = sound;
        return this;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildupMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.amplifier = GsonHelper.m_13927_((JsonObject)json, (String)"level");
        this.potionTime = GsonHelper.m_13927_((JsonObject)json, (String)"potion_time");
        this.radius = GsonHelper.m_13915_((JsonObject)json, (String)"radius");
        this.potion = (MobEffect)MagicUtil.read(json, ForgeRegistries.MOB_EFFECTS, "potion");
        this.affectCaster = GsonHelper.m_13912_((JsonObject)json, (String)"affect_caster");
        this.sound = (SoundEvent)MagicUtil.read(json, ForgeRegistries.SOUND_EVENTS, "sound");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("level", (Number)this.amplifier);
        json.addProperty("potion_time", (Number)this.potionTime);
        json.addProperty("radius", (Number)Float.valueOf(this.radius));
        MagicUtil.write(json, this.potion, "potion");
        json.addProperty("affect_caster", Boolean.valueOf(this.affectCaster));
        MagicUtil.write(json, this.sound, "sound");
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.amplifier = buffer.readInt();
        this.potionTime = buffer.readInt();
        this.radius = buffer.readFloat();
        this.potion = (MobEffect)MagicUtil.decode(buffer);
        this.affectCaster = buffer.readBoolean();
        this.sound = (SoundEvent)MagicUtil.decode(buffer);
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.amplifier);
        buffer.writeInt(this.potionTime);
        buffer.writeFloat(this.radius);
        MagicUtil.encode(buffer, this.potion);
        buffer.writeBoolean(this.affectCaster);
        MagicUtil.encode(buffer, this.sound);
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.potion.m_19482_(), this.levelTranslation()};
    }

    @Override
    protected Object[] getDescrArgs() {
        Object[] args = new Object[5];
        args[0] = this.potion.m_19482_();
        args[1] = this.levelTranslation();
        args[2] = new TextComponent(String.valueOf(this.potionTime / 20));
        Component glue = (double)this.radius > 0.001 ? new TranslatableComponent("gui.wizardstaff.potion_magic.glue") : TextComponent.f_131282_;
        args[3] = this.affectCaster ? new TranslatableComponent("gui.wizardstaff.potion_magic.affect_caster", new Object[]{glue}) : TextComponent.f_131282_;
        args[4] = (double)this.radius > 0.001 ? new TranslatableComponent("gui.wizardstaff.potion_magic.affect_others") : TextComponent.f_131282_;
        return args;
    }

    private Component levelTranslation() {
        if (this.amplifier <= 0) {
            return new TranslatableComponent("enchantment.level.1");
        }
        if (this.amplifier <= 10) {
            return new TranslatableComponent("enchantment.level." + this.amplifier);
        }
        return new TextComponent(String.valueOf(this.amplifier));
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        if (!level.f_46443_) {
            this.cost(player);
            if (this.affectCaster) {
                player.m_7292_(new MobEffectInstance(this.potion, this.potionTime, this.amplifier - 1));
            }
            if ((double)this.radius > 0.001) {
                AABB box = new AABB(player.m_20182_(), player.m_20182_()).m_82400_((double)this.radius);
                for (LivingEntity e2 : level.m_6443_(LivingEntity.class, box, e -> e != player)) {
                    e2.m_7292_(new MobEffectInstance(this.potion, this.potionTime, this.amplifier - 1));
                }
            }
        }
        player.m_5496_(this.sound, 1.0f, this.soundPitch(player));
        return super.magicFinish(level, player, staff);
    }
}

