/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.restructuring;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class SmeltingMagic
extends Magic {
    private RecipeType<? extends Recipe<Container>> recipeType;
    private int interval;
    private SoundEvent sound;
    private String recipeName;
    private int itemCost;

    public SmeltingMagic(MagicType<? extends SmeltingMagic> type) {
        super(type);
    }

    public SmeltingMagic setAdditionalParams(RecipeType<? extends Recipe<Container>> recipeType, int interval, SoundEvent sound, String recipeName, int itemCost) {
        this.recipeType = recipeType;
        this.interval = interval;
        this.sound = sound;
        this.recipeName = recipeName;
        this.itemCost = itemCost;
        return this;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::spinMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.recipeType = (RecipeType)MagicUtil.decode(buffer, Registry.f_122864_);
        this.sound = (SoundEvent)MagicUtil.decode(buffer);
        this.interval = buffer.readInt();
        int nameLength = buffer.readInt();
        this.recipeName = buffer.m_130136_(nameLength);
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        MagicUtil.encode(buffer, this.recipeType, Registry.f_122864_);
        MagicUtil.encode(buffer, this.sound);
        buffer.writeInt(this.interval);
        buffer.writeInt(this.recipeName.length());
        buffer.m_130070_(this.recipeName);
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.recipeType = (RecipeType)MagicUtil.read(json, Registry.f_122864_, "recipe_type");
        this.sound = (SoundEvent)MagicUtil.read(json, ForgeRegistries.SOUND_EVENTS, "sound");
        this.interval = GsonHelper.m_13927_((JsonObject)json, (String)"smelt_interval");
        this.recipeName = GsonHelper.m_13906_((JsonObject)json, (String)"recipe_name");
        this.itemCost = GsonHelper.m_13927_((JsonObject)json, (String)"item_cost");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.recipeType, Registry.f_122864_, "recipe_type");
        MagicUtil.write(json, this.sound, "sound");
        json.addProperty("smelt_interval", (Number)this.interval);
        json.addProperty("recipe_name", this.recipeName);
        json.addProperty("item_cost", (Number)this.itemCost);
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{new TranslatableComponent(this.recipeName)};
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{new TranslatableComponent(this.recipeName)};
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        if (!level.f_46443_ && count % this.interval == 0 && count != this.getUseDuration(staff)) {
            Random rand = player.m_21187_();
            List entities = level.m_6443_(ItemEntity.class, player.m_142469_().m_82400_(2.0), e -> e.m_32055_().m_41613_() >= this.itemCost && !this.getRecipes(level, (ItemEntity)e).isEmpty());
            if (entities.isEmpty()) {
                return;
            }
            ItemEntity itemEntity = (ItemEntity)entities.get(rand.nextInt(entities.size()));
            SimpleContainer inv = new SimpleContainer(new ItemStack[]{itemEntity.m_32055_()});
            List recipes = level.m_7465_().m_44056_(this.recipeType, (Container)inv, level);
            if (!recipes.isEmpty()) {
                this.playSoundServer(level, player, this.sound, 1.0f, this.soundPitch(player));
                this.cost(player);
                Recipe recipe = (Recipe)recipes.get(rand.nextInt(recipes.size()));
                itemEntity.m_32055_().m_41774_(this.itemCost);
                itemEntity.m_19983_(recipe.m_5874_((Container)inv));
            }
        }
    }

    private List<? extends Recipe<Container>> getRecipes(Level level, ItemEntity itemEntity) {
        SimpleContainer inv = new SimpleContainer(new ItemStack[]{itemEntity.m_32055_()});
        return level.m_7465_().m_44056_(this.recipeType, (Container)inv, level);
    }
}

