/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.restructuring;

import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.capability.Wizard;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class SurfaceMagic
extends Magic {
    public SurfaceMagic(MagicType<? extends SurfaceMagic> type) {
        super(type);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildupMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public InteractionResult magicInteractBlock(UseOnContext context) {
        Player player = context.m_43723_();
        if (!context.m_43725_().f_46443_) {
            Wizard.getWizardOptional(player).ifPresent(w -> w.setSurfacePos(context.m_8083_()));
        }
        player.m_5496_(SoundEvents.f_12447_, 1.0f, this.soundPitch(player));
        return InteractionResult.SUCCESS;
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        if (!level.f_46443_) {
            Wizard.getWizardOptional(player).ifPresent(w -> {
                int count = w.createSurface(level, player);
                if (count > 0) {
                    this.cost(player, count);
                } else {
                    this.playSoundServer(level, player, ModSounds.POOF, 1.0f, this.soundPitch(player));
                }
            });
        }
        return super.magicFinish(level, player, staff);
    }
}

