/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.spellbookupdate;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class BookshelfMagic
extends Magic {
    private SoundEvent sound;
    private Item generated;

    public BookshelfMagic(MagicType<? extends BookshelfMagic> type) {
        super(type);
    }

    public BookshelfMagic setAdditionalParams(Item generated, SoundEvent sound) {
        this.generated = generated;
        this.sound = sound;
        return this;
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.generated, "generated");
        MagicUtil.write(json, this.sound, "sound");
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.generated = (Item)MagicUtil.read(json, ForgeRegistries.ITEMS, "generated");
        this.sound = (SoundEvent)MagicUtil.read(json, ForgeRegistries.SOUND_EVENTS, "sound");
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        MagicUtil.encode(buffer, this.generated);
        MagicUtil.encode(buffer, this.sound);
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.generated = (Item)MagicUtil.decode(buffer);
        this.sound = (SoundEvent)MagicUtil.decode(buffer);
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.generated.m_41466_()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return this.getNameArgs();
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::spinMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public void magicTick(Level level, Player player, ItemStack staff, int count) {
        if (!level.f_46443_) {
            this.cost(player);
            if (count % 10 == 0) {
                BehaviorUtils.m_22613_((LivingEntity)player, (ItemStack)new ItemStack((ItemLike)this.generated), (Vec3)this.nearbyPosition(player));
                this.playSoundServer(level, player, this.sound, 1.0f, this.soundPitch(player));
            }
        } else {
            this.addParticle(level, player);
        }
    }

    private void addParticle(Level level, Player player) {
        Vec3 pos = player.m_20182_().m_82520_((player.m_21187_().nextDouble() - 0.5) * 2.0, player.m_21187_().nextDouble() * 1.5, (player.m_21187_().nextDouble() - 0.5) * 2.0);
        double speedX = (player.m_21187_().nextDouble() - 0.5) * 2.0;
        double speedY = player.m_21187_().nextDouble() - 0.5;
        double speedZ = (player.m_21187_().nextDouble() - 0.5) * 2.0;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, pos.m_7096_(), pos.m_7098_() + 1.0, pos.m_7094_(), speedX, speedY, speedZ);
    }

    private Vec3 nearbyPosition(Player player) {
        double x = (player.m_21187_().nextDouble() - 0.5) * 0.3;
        double y = 0.0;
        double z = (player.m_21187_().nextDouble() - 0.5) * 0.3;
        return player.m_20182_().m_82520_(x, y, z);
    }
}

