/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.spellbookupdate;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ConfiguredStructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class MapMagic
extends Magic {
    private static final ImmutableList<StructureInfo> VALID_STRUCTURES = ImmutableList.of((Object)new StructureInfo(ConfiguredStructureTags.f_207637_, MapDecoration.Type.MANSION));

    public MapMagic(MagicType<? extends MapMagic> type) {
        super(type);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::buildup;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        if (!level.f_46443_) {
            ServerLevel serverworld = (ServerLevel)level;
            StructureInfo structureInfo = (StructureInfo)VALID_STRUCTURES.get(player.m_21187_().nextInt(VALID_STRUCTURES.size()));
            BlockPos pos = serverworld.m_207561_(structureInfo.structure, this.randPos(player), 2, true);
            if (pos != null) {
                this.cost(player);
                this.playSoundServer(level, player, ModSounds.SCRIBBLE, 1.0f, this.soundPitch(player));
                ItemStack map = MapItem.m_42886_((Level)serverworld, (int)pos.m_123341_(), (int)pos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverworld, (ItemStack)map);
                MapItemSavedData.m_77925_((ItemStack)map, (BlockPos)pos, (String)"+", (MapDecoration.Type)structureInfo.decoration);
                map.m_41714_(Items.f_42573_.m_41466_());
                WizardStaffItemHandler.getOptional(staff).ifPresent(h -> {
                    h.extractCurrent();
                    h.insertCurrent(map);
                });
            } else {
                this.playSoundServer(level, player, SoundEvents.f_11914_, 1.0f, this.soundPitch(player));
            }
        }
        return super.magicFinish(level, player, staff);
    }

    private BlockPos randPos(Player player) {
        Random rand = player.m_21187_();
        return player.m_142538_().m_142082_(rand.nextInt(1000) - 500, rand.nextInt(1000) - 500, rand.nextInt(1000) - 500);
    }

    private static class StructureInfo {
        private TagKey<ConfiguredStructureFeature<?, ?>> structure;
        private MapDecoration.Type decoration;

        private StructureInfo(TagKey<ConfiguredStructureFeature<?, ?>> structure, MapDecoration.Type decoration) {
            this.structure = structure;
            this.decoration = decoration;
        }
    }
}

