/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class BucketMagic
extends Magic {
    private BucketItem bucket;

    public BucketMagic(MagicType<? extends BucketMagic> type) {
        super(type);
    }

    public BucketMagic setAdditionalParams(BucketItem bucket) {
        this.bucket = bucket;
        return this;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::forwardWaving;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        Item item = (Item)MagicUtil.read(json, ForgeRegistries.ITEMS, "bucket");
        if (!(item instanceof BucketItem)) {
            throw new JsonParseException("bucket attribute must be instance of BucketItem");
        }
        this.bucket = (BucketItem)item;
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.bucket, "bucket");
    }

    @Override
    protected void decodeAdditional(FriendlyByteBuf buffer) {
        this.bucket = (BucketItem)MagicUtil.decode(buffer);
    }

    @Override
    protected void encodeAdditional(FriendlyByteBuf buffer) {
        MagicUtil.encode(buffer, this.bucket);
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.bucket.m_7626_(this.bucket.m_7968_())};
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.bucket.m_7626_(this.bucket.m_7968_())};
    }

    @Override
    public boolean magicPreventOtherUse(Level level, Player player, ItemStack staff) {
        BlockHitResult raytrace = Helper.blockRay(level, player, 4.5f);
        return raytrace.m_6662_() == HitResult.Type.BLOCK;
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        BlockPos pos;
        BlockHitResult raytrace = Helper.blockRay(level, player, 4.5f);
        if (raytrace.m_6662_() == HitResult.Type.BLOCK && this.bucket.m_142073_(player, level, pos = new BlockPos(raytrace.m_82450_()), raytrace)) {
            this.bucket.m_142131_(player, level, new ItemStack((ItemLike)this.bucket), pos);
            if (!level.f_46443_) {
                this.cost(player);
            }
        }
        return super.magicFinish(level, player, staff);
    }
}

