/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class NameTagMagic
extends Magic {
    private List<String> syllables;

    public NameTagMagic(MagicType<? extends NameTagMagic> type) {
        super(type);
    }

    public NameTagMagic setAdditionalParams(List<String> syllables) {
        this.syllables = syllables;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.syllables = MagicUtil.readColl(json, "syllables", e -> GsonHelper.m_13805_((JsonElement)e, (String)"syllable"), new ArrayList());
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.writeColl(json, "syllables", this.syllables, s -> new JsonPrimitive(s));
    }

    @Override
    public UseAnim getUseAnim(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildupMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }

    private String randomName(Random rand) {
        Object name = "";
        for (int i = 0; i < rand.nextInt(3) + 2; ++i) {
            name = (String)name + this.syllables.get(rand.nextInt(this.syllables.size()));
        }
        return StringUtils.capitalize((String)name);
    }

    @Override
    public ItemStack magicFinish(Level level, Player player, ItemStack staff) {
        player.m_5496_(ModSounds.SCRIBBLE, 1.0f, this.soundPitch(player));
        if (!level.f_46443_) {
            WizardStaffItemHandler.getOptional(staff).ifPresent(h -> {
                String name = this.randomName(player.m_21187_());
                this.cost(player);
                ItemStack nametag = h.extractCurrent();
                nametag = Items.f_42656_.m_7968_();
                nametag.m_41714_((Component)new TextComponent(name));
                h.insertCurrent(nametag);
            });
        }
        return super.magicFinish(level, player, staff);
    }
}

